/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.shineatlas.confluence.headingpro.service.SystemAdminService;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSimpleViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SystemSettingViewModel;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUIServlet
extends HttpServlet {
    private final String TEMPLATE_SYSTEM_ADMIN = "templates/system-admin.vm";
    private static final Logger log = LoggerFactory.getLogger(AdminUIServlet.class);
    private final I18nResolver i18nResolver;
    private final UserManager userManager;
    private final SpaceManager spaceManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final PluginLicenseManager licenseManager;
    private final SystemAdminService systemAdminService;

    @Inject
    public AdminUIServlet(@ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager, @ComponentImport SpaceManager spaceManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer renderer, @ComponentImport PluginLicenseManager licenseManager, SystemAdminService systemAdminService) {
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.spaceManager = spaceManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.licenseManager = licenseManager;
        this.systemAdminService = systemAdminService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserProfile user = this.userManager.getRemoteUser(request);
        if (user == null || !this.userManager.isSystemAdmin(user.getUserKey())) {
            this.redirectToLogin(request, response);
            return;
        }
        SystemSettingViewModel systemSetting = this.systemAdminService.getSystemSetting();
        Map context = MacroUtils.defaultVelocityContext();
        context.put("useGlobalSetting", systemSetting.isUseGlobalSetting());
        context.put("setting", systemSetting.getGlobalSetting());
        List spaces = this.spaceManager.getAllSpaces();
        List<SpaceSimpleViewModel> spaceModels = SpaceSimpleViewModel.convertToSpaceViewModels(spaces);
        context.put("spaces", spaces);
        String html = VelocityUtils.getRenderedTemplate((String)"templates/system-admin.vm", (Map)context);
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().write(html);
        response.getWriter().close();
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

