/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.service;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.shineatlas.confluence.headingpro.dao.UserSettingDAO;
import com.shineatlas.confluence.headingpro.domain.UserSettingObject;
import com.shineatlas.confluence.headingpro.exception.EasyHeadingException;
import com.shineatlas.confluence.headingpro.service.UserSettingService;
import com.shineatlas.confluence.headingpro.viewmodel.UserSettingViewModel;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class UserSettingServiceImpl
implements UserSettingService {
    private static final Logger log = LoggerFactory.getLogger(UserSettingServiceImpl.class);
    private final I18nResolver i18nResolver;
    private final UserSettingDAO userSettingDAO;

    @Inject
    public UserSettingServiceImpl(@ComponentImport I18nResolver i18nResolver, UserSettingDAO userSettingDAO) {
        this.i18nResolver = i18nResolver;
        this.userSettingDAO = userSettingDAO;
    }

    @Override
    public UserSettingViewModel getUserSetting(String userKey) throws EasyHeadingException {
        UserSettingViewModel userSetting;
        if (userKey == null || userKey.trim().isEmpty()) {
            throw new EasyHeadingException(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.page.validation.user-key-required"));
        }
        UserSettingObject obj = this.userSettingDAO.find(userKey);
        if (obj == null) {
            userSetting = new UserSettingViewModel(userKey, true);
            this.userSettingDAO.save(userSetting);
        } else {
            userSetting = UserSettingViewModel.convertObjectToViewModel(obj);
        }
        return userSetting;
    }

    @Override
    public UserSettingViewModel saveUserSetting(UserSettingViewModel setting) throws EasyHeadingException {
        if (setting.getUserKey() == null || setting.getUserKey().trim().isEmpty()) {
            throw new EasyHeadingException(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.page.validation.user-key-required"));
        }
        UserSettingObject obj = this.userSettingDAO.save(setting);
        return new UserSettingViewModel(setting.getUserKey(), obj.getEnabled());
    }
}

