/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.service;

import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.shineatlas.confluence.headingpro.StyleTemplates;
import com.shineatlas.confluence.headingpro.dao.SystemSettingDAO;
import com.shineatlas.confluence.headingpro.domain.SysSettingObject;
import com.shineatlas.confluence.headingpro.exception.EasyHeadingException;
import com.shineatlas.confluence.headingpro.service.SpaceAdminService;
import com.shineatlas.confluence.headingpro.service.SystemAdminService;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SystemSettingViewModel;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SystemAdminServiceImpl
implements SystemAdminService {
    private static final Logger log = LoggerFactory.getLogger(SystemAdminServiceImpl.class);
    private final I18nResolver i18nResolver;
    private final ContentService contentService;
    private final SystemSettingDAO systemSettingDAO;
    private final SpaceAdminService spaceAdminService;

    @Inject
    public SystemAdminServiceImpl(@ComponentImport I18nResolver i18nResolver, @ComponentImport ContentService contentService, SystemSettingDAO systemSettingDAO, SpaceAdminService spaceAdminService) {
        this.i18nResolver = i18nResolver;
        this.contentService = contentService;
        this.systemSettingDAO = systemSettingDAO;
        this.spaceAdminService = spaceAdminService;
    }

    @Override
    public SystemSettingViewModel getSystemSetting() {
        SysSettingObject obj = this.systemSettingDAO.getSystemSetting();
        if (obj == null) {
            this.systemSettingDAO.saveSystemSetting(false);
            obj = this.systemSettingDAO.getSystemSetting();
        }
        SpaceSettingViewModel globalSetting = this.spaceAdminService.getSpaceSetting(0L);
        return new SystemSettingViewModel(obj.getUseGlobalSetting(), globalSetting);
    }

    @Override
    public SystemSettingViewModel getSystemDefaultSetting() {
        SystemSettingViewModel systemSetting = this.getSystemSetting();
        SpaceSettingViewModel spaceSetting = SpaceSettingViewModel.createDefaultSetting(0L, true, true);
        return new SystemSettingViewModel(systemSetting.isUseGlobalSetting(), spaceSetting);
    }

    @Override
    public SystemSettingViewModel getSettingByTemplate(String templateName) {
        SpaceSettingViewModel spaceSetting;
        SystemSettingViewModel systemSetting = this.getSystemSetting();
        switch (templateName) {
            case "orange": {
                spaceSetting = StyleTemplates.OrangeStandard(systemSetting.getGlobalSetting());
                break;
            }
            case "green": {
                spaceSetting = StyleTemplates.GreenStandard(systemSetting.getGlobalSetting());
                break;
            }
            default: {
                spaceSetting = StyleTemplates.BlueStandard(systemSetting.getGlobalSetting());
            }
        }
        return new SystemSettingViewModel(systemSetting.isUseGlobalSetting(), spaceSetting);
    }

    @Override
    public SpaceSettingViewModel saveSystemSetting(boolean useGlobalSetting) {
        this.systemSettingDAO.saveSystemSetting(useGlobalSetting);
        SystemSettingViewModel systemSetting = this.getSystemSetting();
        return systemSetting.getGlobalSetting();
    }

    @Override
    public SpaceSettingViewModel saveSystemSetting(SystemSettingViewModel model) throws EasyHeadingException {
        this.systemSettingDAO.saveSystemSetting(model.isUseGlobalSetting());
        this.spaceAdminService.saveSpaceSetting(model.getGlobalSetting());
        SystemSettingViewModel systemSetting = this.getSystemSetting();
        return systemSetting.getGlobalSetting();
    }
}

