/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.service;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.shineatlas.confluence.headingpro.StyleTemplates;
import com.shineatlas.confluence.headingpro.dao.SpaceSettingDAO;
import com.shineatlas.confluence.headingpro.domain.SpaceSettingObject;
import com.shineatlas.confluence.headingpro.exception.EasyHeadingException;
import com.shineatlas.confluence.headingpro.helper.LicenseHelper;
import com.shineatlas.confluence.headingpro.service.SpaceAdminService;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SpaceAdminServiceImpl
implements SpaceAdminService {
    private static final Logger log = LoggerFactory.getLogger(SpaceAdminServiceImpl.class);
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final SpaceManager spaceManager;
    private final TemplateRenderer renderer;
    private final SpaceSettingDAO spaceSettingDAO;

    @Inject
    public SpaceAdminServiceImpl(@ComponentImport I18nResolver i18nResolver, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport SpaceManager spaceManager, @ComponentImport TemplateRenderer renderer, SpaceSettingDAO spaceSettingDAO) {
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.spaceManager = spaceManager;
        this.renderer = renderer;
        this.spaceSettingDAO = spaceSettingDAO;
    }

    @Override
    public SpaceSettingViewModel getSpaceSetting(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.getSpaceSetting(space.getId());
    }

    @Override
    public SpaceSettingViewModel getSpaceSetting(long spaceId) {
        SpaceSettingViewModel spaceSetting;
        SpaceSettingObject obj = this.spaceSettingDAO.find(spaceId);
        if (obj == null) {
            spaceSetting = SpaceSettingViewModel.createDefaultSetting(spaceId, true, true);
            this.spaceSettingDAO.save(spaceSetting);
        } else {
            spaceSetting = SpaceSettingViewModel.convertObjectToViewModel(obj);
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("setting", spaceSetting);
        String navigationCssStyle = VelocityUtils.getRenderedTemplate((String)"templates/navigation-style.vm", (Map)context);
        spaceSetting.setNavigationCssStyle(navigationCssStyle);
        String licenseError = LicenseHelper.getLicenseErrorMessage(this.pluginLicenseManager, this.i18nResolver);
        spaceSetting.setLicenseError(licenseError);
        return spaceSetting;
    }

    @Override
    public SpaceSettingViewModel getSpaceDefaultSetting(long spaceId) {
        SpaceSettingViewModel model = this.getSpaceSetting(spaceId);
        SpaceSettingViewModel spaceSetting = SpaceSettingViewModel.createDefaultSetting(spaceId, model.isEnabled(), model.isEnabledForHome());
        String licenseError = LicenseHelper.getLicenseErrorMessage(this.pluginLicenseManager, this.i18nResolver);
        spaceSetting.setLicenseError(licenseError);
        return spaceSetting;
    }

    @Override
    public SpaceSettingViewModel getSettingByTemplate(long spaceId, String templateName) {
        SpaceSettingViewModel spaceSetting = this.getSpaceSetting(spaceId);
        switch (templateName) {
            case "orange": {
                spaceSetting = StyleTemplates.OrangeStandard(spaceSetting);
                break;
            }
            case "green": {
                spaceSetting = StyleTemplates.GreenStandard(spaceSetting);
                break;
            }
            default: {
                spaceSetting = StyleTemplates.BlueStandard(spaceSetting);
            }
        }
        String licenseError = LicenseHelper.getLicenseErrorMessage(this.pluginLicenseManager, this.i18nResolver);
        spaceSetting.setLicenseError(licenseError);
        return spaceSetting;
    }

    @Override
    public void saveSpaceSetting(SpaceSettingViewModel setting) throws EasyHeadingException {
        if (setting == null) {
            throw new EasyHeadingException(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.validation.space-required"));
        }
        if (setting.getSpaceId() < 0L) {
            throw new EasyHeadingException(this.i18nResolver.getText("com.shineatlas.confluence.headingpro.easy-heading-pro.admin.validation.space-id-required"));
        }
        this.spaceSettingDAO.save(setting);
    }

    @Override
    public void saveSpaceSetting(long spaceId, boolean enabled) throws EasyHeadingException {
        SpaceSettingViewModel model = this.getSpaceSetting(spaceId);
        if (model == null) {
            model = SpaceSettingViewModel.createDefaultSetting(spaceId, false, false);
        }
        model.setEnabled(enabled);
        this.saveSpaceSetting(model);
    }

    @Override
    public void saveSpaceSettingEnabledForHome(long spaceId, boolean enabledForHome) throws EasyHeadingException {
        SpaceSettingViewModel model = this.getSpaceSetting(spaceId);
        if (model == null) {
            model = SpaceSettingViewModel.createDefaultSetting(spaceId, false, false);
        }
        model.setEnabledForHome(enabledForHome);
        this.saveSpaceSetting(model);
    }
}

