/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.service;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.shineatlas.confluence.headingpro.service.PageEditorParameterService;
import com.shineatlas.confluence.headingpro.service.SpaceAdminService;
import com.shineatlas.confluence.headingpro.service.SystemAdminService;
import com.shineatlas.confluence.headingpro.viewmodel.PageEditorParameterViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SpaceSettingViewModel;
import com.shineatlas.confluence.headingpro.viewmodel.SystemSettingViewModel;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PageEditorParameterServiceImpl
implements PageEditorParameterService {
    private static final Logger log = LoggerFactory.getLogger(PageEditorParameterServiceImpl.class);
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager pluginLicenseManager;
    private final SpaceAdminService spaceAdminService;
    private final SystemAdminService systemAdminService;

    @Inject
    public PageEditorParameterServiceImpl(@ComponentImport I18nResolver i18nResolver, @ComponentImport PluginLicenseManager pluginLicenseManager, SpaceAdminService spaceAdminService, SystemAdminService systemAdminService) {
        this.i18nResolver = i18nResolver;
        this.pluginLicenseManager = pluginLicenseManager;
        this.spaceAdminService = spaceAdminService;
        this.systemAdminService = systemAdminService;
    }

    @Override
    public SpaceSettingViewModel getSpaceSetting(String spaceKey) {
        SystemSettingViewModel systemSetting = this.systemAdminService.getSystemSetting();
        SpaceSettingViewModel spaceSetting = systemSetting.isUseGlobalSetting() ? systemSetting.getGlobalSetting() : this.spaceAdminService.getSpaceSetting(spaceKey);
        return spaceSetting;
    }

    @Override
    public PageEditorParameterViewModel getPageEditorParameters(String spaceKey) {
        SystemSettingViewModel systemSetting = this.systemAdminService.getSystemSetting();
        SpaceSettingViewModel spaceSetting = systemSetting.isUseGlobalSetting() ? systemSetting.getGlobalSetting() : this.spaceAdminService.getSpaceSetting(spaceKey);
        return new PageEditorParameterViewModel(spaceSetting.getLicenseError(), spaceSetting.getNavigationEditMode(), spaceSetting.getMacrosTOCDisabled());
    }
}

