/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.service;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.shineatlas.confluence.headingpro.dao.DeactivatedContentDAO;
import com.shineatlas.confluence.headingpro.domain.DeactivatedContentObject;
import com.shineatlas.confluence.headingpro.service.ConfluenceContentService;
import com.shineatlas.confluence.headingpro.service.ContentDeactivationService;
import com.shineatlas.confluence.headingpro.viewmodel.ContentDeactivationViewModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ContentDeactivationServiceImpl
implements ContentDeactivationService {
    private static final Logger log = LoggerFactory.getLogger(ContentDeactivationServiceImpl.class);
    private final ContentService contentService;
    private final SpaceService spaceService;
    private final ConfluenceContentService confluenceContentService;
    private final DeactivatedContentDAO deactivatedContentDAO;

    @Inject
    public ContentDeactivationServiceImpl(@ComponentImport ContentService contentService, @ComponentImport(value="APISpaceService") SpaceService spaceService, ConfluenceContentService confluenceContentService, DeactivatedContentDAO deactivatedContentDAO) {
        this.contentService = contentService;
        this.spaceService = spaceService;
        this.confluenceContentService = confluenceContentService;
        this.deactivatedContentDAO = deactivatedContentDAO;
    }

    @Override
    public ContentDeactivationViewModel getContentDeactivation(long contentId) {
        Content content = (Content)this.contentService.find(new Expansion[]{new Expansion("space")}).withId(ContentId.valueOf((String)String.valueOf(contentId))).fetchOne().getOrNull();
        if (content == null) {
            return null;
        }
        return this.createContentDeactivationViewModel(content);
    }

    @Override
    public List<ContentDeactivationViewModel> getAllContentDeactivations(String spaceKey) {
        DeactivatedContentObject[] objects;
        ArrayList<ContentDeactivationViewModel> result = new ArrayList<ContentDeactivationViewModel>();
        for (DeactivatedContentObject obj : objects = this.deactivatedContentDAO.findAll()) {
            ContentDeactivationViewModel model;
            Content content = (Content)this.contentService.find(new Expansion[]{new Expansion("space")}).withId(ContentId.valueOf((String)String.valueOf(obj.getIndexedContentId()))).fetchOne().getOrNull();
            if (content == null || (model = this.createContentDeactivationViewModel(content)) == null || !spaceKey.isEmpty() && !spaceKey.equals(model.getSpaceKey())) continue;
            result.add(model);
        }
        return result;
    }

    @Override
    public List<ContentDeactivationViewModel> searchContentForDeactivation(String title) {
        PageRequest pageRequest = new PageRequest(){

            public int getStart() {
                return 0;
            }

            public int getLimit() {
                return 10;
            }
        };
        List temp = this.contentService.find(new Expansion[]{new Expansion("space")}).withTitle(title).fetchMany(ContentType.PAGE, pageRequest).getResults();
        List result1 = this.contentService.find(new Expansion[]{new Expansion("space")}).withTitle(title).withSpace(new com.atlassian.confluence.api.model.content.Space[0]).fetchMany(ContentType.PAGE, pageRequest).getResults().stream().map(p -> this.createContentDeactivationViewModel((Content)p)).collect(Collectors.toList());
        List result2 = this.contentService.find(new Expansion[]{new Expansion("space")}).withTitle(title).fetchMany(ContentType.BLOG_POST, pageRequest).getResults().stream().map(p -> this.createContentDeactivationViewModel((Content)p)).collect(Collectors.toList());
        return Stream.concat(result1.stream(), result2.stream()).collect(Collectors.toList());
    }

    @Override
    public List<ContentDeactivationViewModel> searchContentForDeactivation(String spaceKey, String title) {
        if (title.isEmpty()) {
            new ArrayList();
        }
        PageRequest pageRequest = new PageRequest(){

            public int getStart() {
                return 0;
            }

            public int getLimit() {
                return 10;
            }
        };
        com.atlassian.confluence.api.model.content.Space space = (com.atlassian.confluence.api.model.content.Space)this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetchOne().getOrNull();
        if (space == null) {
            return new ArrayList<ContentDeactivationViewModel>();
        }
        List result1 = this.contentService.find(new Expansion[]{new Expansion("space")}).withTitle(title).withSpace(new com.atlassian.confluence.api.model.content.Space[]{space}).fetchMany(ContentType.PAGE, pageRequest).getResults().stream().map(p -> this.createContentDeactivationViewModel((Content)p)).collect(Collectors.toList());
        List result2 = this.contentService.find(new Expansion[]{new Expansion("space")}).withTitle(title).withSpace(new com.atlassian.confluence.api.model.content.Space[]{space}).fetchMany(ContentType.BLOG_POST, pageRequest).getResults().stream().map(p -> this.createContentDeactivationViewModel((Content)p)).collect(Collectors.toList());
        return Stream.concat(result1.stream(), result2.stream()).collect(Collectors.toList());
    }

    @Override
    public ContentDeactivationViewModel deactivateContent(long contentId, boolean beingDeactivated) {
        DeactivatedContentObject object = this.deactivatedContentDAO.find(contentId);
        if (object != null) {
            if (!beingDeactivated) {
                this.deactivatedContentDAO.remove(contentId);
            }
        } else if (beingDeactivated) {
            this.deactivatedContentDAO.add(contentId);
        }
        Content content = (Content)this.contentService.find(new Expansion[]{new Expansion("space")}).withId(ContentId.of((long)contentId)).fetchOne().getOrNull();
        return this.createContentDeactivationViewModel(content);
    }

    private ContentDeactivationViewModel createContentDeactivationViewModel(Content content) {
        long id = content.getId().asLong();
        String url = "";
        if (content.getType() == ContentType.PAGE) {
            url = this.confluenceContentService.getPage(id).getUrlPath();
        } else if (content.getType() == ContentType.BLOG_POST) {
            url = this.confluenceContentService.getBlogPost(id).getUrlPath();
        }
        String spaceKey = content.getSpace().getKey();
        Space space = this.confluenceContentService.getSpace(spaceKey);
        DeactivatedContentObject obj = this.deactivatedContentDAO.find(id);
        boolean deactivated = obj != null;
        return new ContentDeactivationViewModel(id, content.getTitle(), url, content.getSpace().getKey(), content.getSpace().getName(), space.getUrlPath(), content.getType().getType(), deactivated);
    }
}

