/*
 * Decompiled with CFR 0.152.
 */
package com.shineatlas.confluence.headingpro.domain.upgrade.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.shineatlas.confluence.headingpro.domain.upgrade.v2.SpaceSettingObject;
import com.shineatlas.confluence.headingpro.domain.upgrade.v2.UserSettingObject;
import java.util.ArrayList;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectUpgradeTask1
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(ObjectUpgradeTask1.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        ao.migrate(new Class[]{SpaceSettingObject.class});
        ao.migrate(new Class[]{UserSettingObject.class});
        ArrayList<Long> IndexedSpaceIds = new ArrayList<Long>();
        for (SpaceSettingObject obj : (SpaceSettingObject[])ao.find(SpaceSettingObject.class)) {
            long indexedSpaceId = obj.getIndexedSpaceId();
            if (IndexedSpaceIds.contains(indexedSpaceId)) {
                ao.delete(new RawEntity[]{obj});
                continue;
            }
            IndexedSpaceIds.add(obj.getSpaceId());
        }
        ArrayList<String> indexedUserKeys = new ArrayList<String>();
        for (UserSettingObject obj : (UserSettingObject[])ao.find(UserSettingObject.class)) {
            String indexedUserKey = obj.getIndexedUserKey();
            if (indexedUserKey == null || indexedUserKey.isEmpty() || indexedUserKeys.contains(indexedUserKey)) {
                ao.delete(new RawEntity[]{obj});
                continue;
            }
            indexedUserKeys.add(indexedUserKey);
        }
    }
}

