/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.utils;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.exceptions.IMessageException;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.web.models.errors.DhUserErrorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(ResponseBuilder.class);
    private static DHObjectMapper mapper = new DHObjectMapperImpl();

    public static final Response.ResponseBuilder create(int status) {
        return ResponseBuilder.create(status, null);
    }

    public static final Response.ResponseBuilder create(int status, Object entity) {
        Response.ResponseBuilder rb = Response.status((int)status);
        if (entity != null) {
            if (entity instanceof String) {
                rb.entity(entity);
            } else {
                if (entity instanceof InputStream) {
                    try {
                        rb.entity((Object)mapper.writeInputStreamAsString((InputStream)entity));
                    }
                    catch (IOException e) {
                        log.warn("Error on ResponseBuilder creating a response of an input stream", (Throwable)e);
                        return rb.status(500);
                    }
                }
                try {
                    rb.entity((Object)mapper.writeValueAsString(entity));
                }
                catch (IOException e) {
                    log.warn("Error on ResponseBuilder creating a response", (Throwable)e);
                    return rb.status(500);
                }
            }
        }
        return rb;
    }

    public static final Response.ResponseBuilder ok(Object entity) {
        return ResponseBuilder.create(200, entity);
    }

    public static final Response createErrorFrom(IMessageException e) {
        return ResponseBuilder.create(e.getCode(), ResponseBuilder.createErrorMessage(e)).build();
    }

    private static final Map<String, String> createErrorMessage(IMessageException e) {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("error", e.getMessage());
        return response;
    }

    public static Response create(Response resp, Map<String, Object> headers) {
        Response.ResponseBuilder builder = ResponseBuilder.create(resp.getStatus(), resp.getEntity());
        if (headers != null && !headers.isEmpty()) {
            headers.keySet().stream().forEach(key -> builder.header(key, headers.get(key)));
        }
        return builder.build();
    }

    public static Response create(Response resp) {
        return ResponseBuilder.create(resp, null);
    }

    public static Response createParseErrorResponse(IOException e) {
        return Response.status((int)400).entity((Object)e.getMessage()).build();
    }

    public static Response createParseErrorResponse(Exception e) {
        DhUserErrorModel dhUserError = new DhUserErrorModel();
        int statusResponseCode = 400;
        if (e.getMessage() != null) {
            if (e.getMessage().contains("CONFLICT")) {
                dhUserError.setMessage("CONFLICT");
                statusResponseCode = 409;
            } else {
                dhUserError.setMessage(e.getMessage());
            }
        } else {
            dhUserError.setErrorKey("INVALID_INSTANCE");
        }
        Map<String, DhUserErrorModel> body = Collections.singletonMap("dhUserError", dhUserError);
        return Response.status((int)statusResponseCode).entity(body).build();
    }

    public static Response createErrorResponseFrom(DhUserException e) {
        DhUserErrorModel dhUserError = new DhUserErrorModel();
        dhUserError.setErrorKey(e.getKey());
        dhUserError.setLogLevel(e.getLevel());
        dhUserError.setErrorId(e.getId());
        dhUserError.setApiResponseStatus(e.getCode());
        dhUserError.setMessage(e.getMessage());
        Map<String, DhUserErrorModel> body = Collections.singletonMap("dhUserError", dhUserError);
        return Response.status((int)400).entity(body).build();
    }

    public static Response handleApiResponse(Exception e, String defaultMessage) {
        if (e instanceof DhUserException) {
            return ResponseBuilder.createErrorResponseFrom((DhUserException)e);
        }
        log.error(defaultMessage, (Throwable)e);
        if (e instanceof BadRequestToSourceException) {
            return ResponseBuilder.createErrorFrom((BadRequestToSourceException)e);
        }
        return Response.status((int)400).build();
    }
}

