/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.proxy;

import com.roninpixels.dashboardhub.controllers.ImageController;
import com.roninpixels.dashboardhub.exceptions.ImageTypeException;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.ImageMimeTypeModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ImageProxyEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ImageProxyEndpoint.class);
    @Autowired
    private ImageController imageController;
    @Autowired
    private DatasourcesController datasourcesController;
    @Autowired
    private DHObjectMapper mapper;
    @Autowired
    private Crypto crypto;

    private static final String getExpirationTime() {
        return ZonedDateTime.now().plusYears(1L).format(DateTimeFormatter.ISO_DATE_TIME);
    }

    private String getUrlDomain(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        try {
            URL parsedUrl = new URL(url);
            String protocol = parsedUrl.getProtocol();
            String host = parsedUrl.getHost();
            int port = parsedUrl.getPort();
            return protocol + "://" + host + (port != -1 ? ":" + port : "");
        }
        catch (Exception e) {
            log.error("Error parsing URL: {}", (Object)url, (Object)e);
            return null;
        }
    }

    public Response get(@NotNull @HeaderParam(value="dsextraconfig") String dsextraconfig, @Context UriInfo ui) {
        try {
            DatasourceModel datasource;
            MultivaluedMap params = ui.getQueryParameters();
            String encryptedRoute = (String)((LinkedList)params.get((Object)"route")).get(0);
            String route = this.crypto.decryptFrontend(encryptedRoute);
            Map dsExtraConfigMap = this.mapper.readValue(new String(Base64.getDecoder().decode(dsextraconfig)), HashMap.class);
            String finalRoute = route;
            if (!route.startsWith("http") && (datasource = this.datasourcesController.getDatasource((String)dsExtraConfigMap.get("datasourceId"))) != null && datasource.getUrl() != null) {
                String urlDomain = this.getUrlDomain(datasource.getUrl());
                finalRoute = urlDomain + (route.startsWith("/") ? route : "/" + route);
            }
            ImageMimeTypeModel image = this.imageController.getImageByteArray((String)dsExtraConfigMap.get("datasourceId"), finalRoute);
            return Response.status((int)200).entity((Object)image.getImageByteArray()).header("Content-Type", (Object)image.getMimeType()).header("Content-Length", (Object)String.valueOf(image.getImageByteArray().length)).build();
        }
        catch (ImageTypeException ime) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", ime.getMessage());
            return ResponseBuilder.create(400, error).build();
        }
        catch (Exception e) {
            return Response.status((int)404).build();
        }
    }
}

