/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.jira.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.services.controllers.JiraDatasourcesController;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.rest.base.jira.api.GenericJiraEndpoint;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class GlobalConfigurationEndpoint {
    private static final Logger log = LoggerFactory.getLogger(GlobalConfigurationEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;
    @Inject
    private JiraDatasourcesController jiraDatasourcesController;

    public Response get(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            DatasourceModel datasourceModel = this.connProvider.getDatasourceFrom(datasourceinfo);
            JiraConnector jiraConnector = this.jiraDatasourcesController.getJiraConnector(datasourceModel);
            ResponseEntity<String> response = jiraConnector.configuration();
            return GenericJiraEndpoint.generateResponse(response, null);
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting configuration settings");
        }
    }
}

