/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.jira.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.web.rest.base.jira.api.GenericJiraEndpoint;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class FieldsEndpoint {
    private static final Logger log = LoggerFactory.getLogger(FieldsEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    public Response get(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ResponseEntity<String> response = jira.getFields();
            return GenericJiraEndpoint.generateResponse(response, "fields");
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting jira fields");
        }
    }
}

