/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.customReports;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.roninpixels.dashboardhub.controllers.UserTemplateController;
import com.roninpixels.dashboardhub.web.models.UserTemplateModel;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/customReports/userTemplates")
@Component
public class UserTemplatesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(UserTemplatesEndpoint.class);
    @Inject
    private UserTemplateController userTemplateController;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @GET
    @Produces(value={"application/json"})
    public Response getUserTemplates(@QueryParam(value="includeDisabled") String includeDisabled) {
        try {
            boolean includeDisabledFlag = "true".equalsIgnoreCase(includeDisabled);
            List<UserTemplateModel> templates = this.userTemplateController.getUserTemplates(includeDisabledFlag);
            return Response.ok(templates).build();
        }
        catch (Exception e) {
            log.error("Error getting user templates", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error retrieving user templates: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/{templateId}")
    @Produces(value={"application/json"})
    public Response getUserTemplate(@PathParam(value="templateId") String templateId) {
        try {
            if (templateId == null || templateId.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Template ID is required").build();
            }
            UserTemplateModel template = this.userTemplateController.getUserTemplate(templateId);
            if (template == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Template not found").build();
            }
            return Response.ok((Object)template).build();
        }
        catch (Exception e) {
            log.error(String.format("Error getting user template with ID: %s", templateId), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error retrieving user template: " + e.getMessage())).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createUserTemplate(String templateData) {
        try {
            if (templateData == null || templateData.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Template data is required").build();
            }
            UserTemplateModel template = this.parseTemplateFromJson(templateData);
            if (template == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON format for template data").build();
            }
            UserTemplateModel createdTemplate = this.userTemplateController.createUserTemplate(template);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)createdTemplate).build();
        }
        catch (IllegalArgumentException e) {
            log.warn(String.format("Invalid template data: %s", e.getMessage()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid template data: " + e.getMessage())).build();
        }
        catch (Exception e) {
            log.error("Error creating user template", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error creating user template: " + e.getMessage())).build();
        }
    }

    @PUT
    @Path(value="/{templateId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUserTemplate(@PathParam(value="templateId") String templateId, String templateData) {
        try {
            if (templateId == null || templateId.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Template ID is required").build();
            }
            if (templateData == null || templateData.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Template data is required").build();
            }
            UserTemplateModel template = this.parseTemplateFromJson(templateData);
            if (template == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON format for template data").build();
            }
            UserTemplateModel updatedTemplate = this.userTemplateController.updateUserTemplate(templateId, template);
            return Response.ok((Object)updatedTemplate).build();
        }
        catch (IllegalArgumentException e) {
            log.warn(String.format("Invalid template data: %s", e.getMessage()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid template data: " + e.getMessage())).build();
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("not found")) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Template not found").build();
            }
            log.error(String.format("Error updating user template with ID: %s", templateId), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error updating user template: " + e.getMessage())).build();
        }
        catch (Exception e) {
            log.error(String.format("Error updating user template with ID: %s", templateId), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error updating user template: " + e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="/{templateId}")
    @Produces(value={"application/json"})
    public Response deleteUserTemplate(@PathParam(value="templateId") String templateId) {
        try {
            if (templateId == null || templateId.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Template ID is required").build();
            }
            UserTemplateModel deletedTemplate = this.userTemplateController.deleteUserTemplate(templateId);
            return Response.ok((Object)deletedTemplate).build();
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("not found")) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Template not found").build();
            }
            log.error(String.format("Error deleting user template with ID: %s", templateId), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error deleting user template: " + e.getMessage())).build();
        }
        catch (Exception e) {
            log.error(String.format("Error deleting user template with ID: %s", templateId), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error deleting user template: " + e.getMessage())).build();
        }
    }

    private UserTemplateModel parseTemplateFromJson(String jsonData) {
        try {
            return this.objectMapper.readValue(jsonData, UserTemplateModel.class);
        }
        catch (Exception e) {
            log.error(String.format("Error parsing template JSON: %s", jsonData), (Throwable)e);
            return null;
        }
    }
}

