/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.customReports;

import com.roninpixels.dashboardhub.license.rulesImpl.DEVModeRule;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import java.io.InputStream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/customReports/templates")
public class CustomReportsTemplates {
    private static final Logger log = LoggerFactory.getLogger(CustomReportsTemplates.class);
    private final boolean DEBUG;
    private final String VERSION;

    @Inject
    public CustomReportsTemplates(DashboardHubPluginManager dashboardHubPluginManager, DEVModeRule devModeRule) {
        this.DEBUG = devModeRule.isDevModeEnabled();
        this.VERSION = dashboardHubPluginManager.getPluginVersion();
    }

    @GET
    @Produces(value={"application/json"})
    public Response doRequest() {
        try {
            InputStream inputStream = CustomReportsTemplates.class.getClassLoader().getResourceAsStream("/globalTemplates.json");
            Response.ResponseBuilder builder = Response.ok((Object)inputStream, (String)"application/octet-stream").header("Content-Disposition", (Object)"attachment; filename=\"globalTemplates.json\"");
            if (!this.DEBUG) {
                builder.tag(this.VERSION).header("Cache-Control", (Object)"public, max-age=31536000");
            }
            return builder.build();
        }
        catch (Exception e) {
            log.error("Problems getting the global templates file", (Throwable)e);
            return Response.status((int)500).entity((Object)"File not found").build();
        }
    }
}

