/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.bigpicture.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.BigPictureConnector;
import com.roninpixels.dashboardhub.controllers.bigpicture.BigPictureController;
import com.roninpixels.dashboardhub.controllers.bigpicture.BigPictureControllerImpl;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.Box;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxIdsFieldIdsRequest;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskBoxFieldValues;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

public class BigPictureEndpoint {
    @Inject
    private ConnectorsProvider connProvider;
    @Inject
    private DHObjectMapper mapper;

    BigPictureController getController(String datasourceinfo) {
        BigPictureConnector bigPicture = (BigPictureConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
        BigPictureControllerImpl bigPictureController = new BigPictureControllerImpl(bigPicture);
        return bigPictureController;
    }

    public Response getBoxFields(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            BigPictureController bigPictureController = this.getController(datasourceinfo);
            List<Map> boxFields = bigPictureController.getBoxFields();
            return ResponseBuilder.create(200, boxFields).build();
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting bigPicture box fields");
        }
    }

    public Response getBoxTypes(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            BigPictureController bigPictureController = this.getController(datasourceinfo);
            List<Map> boxTypes = bigPictureController.getBoxTypes();
            return ResponseBuilder.create(200, boxTypes).build();
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting bigPicture box types");
        }
    }

    public Response getBoxStatuses(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            BigPictureController bigPictureController = this.getController(datasourceinfo);
            List<Map> boxStatuses = bigPictureController.getBoxStatuses();
            return ResponseBuilder.create(200, boxStatuses).build();
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting bigPicture statuses");
        }
    }

    public Response getBoxesTree(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            BigPictureController bigPictureController = this.getController(datasourceinfo);
            Box boxesTree = bigPictureController.getBoxesTree();
            return ResponseBuilder.create(200, boxesTree).build();
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting bigPicture boxes tree");
        }
    }

    public Response getBoxFieldValues(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, String requestBody) {
        try {
            BigPictureController bigPictureController = this.getController(datasourceinfo);
            BoxIdsFieldIdsRequest request = this.mapper.readValue(requestBody, BoxIdsFieldIdsRequest.class);
            Map<String, Map<String, Map>> boxFieldValues = bigPictureController.getBoxFieldValues(request.getBoxIds(), request.getFieldIds());
            return ResponseBuilder.create(200, boxFieldValues).build();
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting bigPicture boxes field values");
        }
    }

    public Response getColors(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            BigPictureController bigPictureController = this.getController(datasourceinfo);
            List<Map> colors = bigPictureController.getColors();
            return ResponseBuilder.create(200, colors).build();
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting bigPicture colors");
        }
    }

    public Response getTaskFields(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            BigPictureController bigPictureController = this.getController(datasourceinfo);
            List<Map> taskFields = bigPictureController.getTaskFields();
            return ResponseBuilder.create(200, taskFields).build();
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting bigPicture task fields");
        }
    }

    public Response getTaskFieldsValues(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, String requestBody) {
        try {
            BigPictureController bigPictureController = this.getController(datasourceinfo);
            BoxIdsFieldIdsRequest request = this.mapper.readValue(requestBody, BoxIdsFieldIdsRequest.class);
            List<TaskBoxFieldValues> taskFieldValues = bigPictureController.getTaskFieldsValues(request.getBoxIds(), request.getFieldIds());
            return ResponseBuilder.create(200, taskFieldValues).build();
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting bigPicture tasks field values");
        }
    }

    public Response getBoxObjectives(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo, @NotNull @PathParam(value="id") String boxId) {
        return Response.status((int)404).build();
    }

    public Response getWorkingScheme(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            BigPictureController bigPictureController = this.getController(datasourceinfo);
            Map workingScheme = bigPictureController.getWorkingScheme();
            return ResponseBuilder.create(200, (Object)workingScheme).build();
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting bigPicture working scheme");
        }
    }
}

