/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.permissions.rules;

import com.roninpixels.dashboardhub.permissions.EditPermission;
import com.roninpixels.dashboardhub.permissions.UsePermission;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.permissions.BoardRestrictionsConfig;
import com.roninpixels.dashboardhub.utils.permissions.RestrictionsUtil;
import com.roninpixels.dashboardhub.web.models.RestrictionModel;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="someUseSomeEdit_USERS")
public class SomeCanEditUseForUsersRule
implements UsePermission,
EditPermission {
    public static final String PERMISSION_TYPE = "someUseSomeEdit_USERS";
    @Inject
    private DHUserService dhUserService;

    @Override
    public boolean evaluateUse(RestrictionModel restrictionModel) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        BoardRestrictionsConfig config = RestrictionsUtil.getRestrictionsConfig(restrictionModel.getRestrictions());
        return currentUser.equals(restrictionModel.getOwner()) || config.canUseUser(currentUser) || this.evaluateEdit(restrictionModel);
    }

    @Override
    public boolean evaluateEdit(RestrictionModel restrictionModel) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        BoardRestrictionsConfig config = RestrictionsUtil.getRestrictionsConfig(restrictionModel.getRestrictions());
        return currentUser.equals(restrictionModel.getOwner()) || config.canEditUser(currentUser);
    }
}

