/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.permissions.rules;

import com.roninpixels.dashboardhub.permissions.EditPermission;
import com.roninpixels.dashboardhub.permissions.UsePermission;
import com.roninpixels.dashboardhub.permissions.rules.SomeCanEditUseForUsersRule;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.models.RestrictionModel;
import com.roninpixels.dashboardhub.web.models.RestrictionsModel;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="anyUseSomeEdit_USERS")
public class AnyoneUseSomeEditForUsersRule
implements UsePermission,
EditPermission {
    public static final String PERMISSION_TYPE = "anyUseSomeEdit_USERS";
    @Inject
    private DHUserService dhUserService;
    @Inject
    private SomeCanEditUseForUsersRule someCanEditUseForUsersRule;

    @Override
    public boolean evaluateUse(RestrictionModel restrictionModel) {
        String currentUser = this.dhUserService.getLoggedInUserKey();
        if (currentUser == null) {
            return false;
        }
        RestrictionsModel restrictions = restrictionModel.getRestrictions();
        return restrictions == null || PERMISSION_TYPE.startsWith(restrictions.getType());
    }

    @Override
    public boolean evaluateEdit(RestrictionModel restrictionModel) {
        return this.someCanEditUseForUsersRule.evaluateEdit(restrictionModel);
    }
}

