/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.jcma.entityExporters.impl;

import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.jcma.entityExporters.GenericRepositoryExporter;
import com.roninpixels.dashboardhub.store.DHDatasourcesRepository;
import com.roninpixels.dashboardhub.utils.crypto.RSACryptoService;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourcesExporter
extends GenericRepositoryExporter<DatasourceModel> {
    private static final Logger log = LoggerFactory.getLogger(DatasourcesExporter.class);
    public static final String LABEL = "SavedDatasourceEntity";
    @Inject
    private DatasourcesUtil datasourcesUtil;
    @Inject
    private RSACryptoService rsaService;
    @Inject
    private DHObjectMapper mapper;

    @Inject
    public DatasourcesExporter(DHDatasourcesRepository repo) {
        super(repo);
    }

    @Override
    protected Object prepareToExport(DatasourceModel modelObj) {
        DsOptionsModel options = this.datasourcesUtil.getSecretOptions(modelObj.getToken());
        modelObj.setToken(null);
        if (options != null && options.getOtherConfig() != null && !options.getOtherConfig().isEmpty()) {
            modelObj.setOptions(null);
            try {
                String clearOptions = this.mapper.writeValueAsString(options);
                String newRSAToken = this.rsaService.encrypt(clearOptions);
                modelObj.setToken(newRSAToken);
            }
            catch (IOException | GeneralSecurityException e) {
                log.error(String.format("The datasource %s secrets options cannot be included", modelObj.getId()), (Throwable)e);
            }
        }
        return modelObj;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }
}

