/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.projectrak;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.projectrak.PQLSearch;
import com.roninpixels.dashboardhub.gadgetsRequesters.projectrak.ProjectrakGadgetRequesterBase;
import com.roninpixels.dashboardhub.gadgetsRequesters.projectrak.ProjectrakPQLConfig;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectrakPQL
extends ProjectrakGadgetRequesterBase {
    private static final Logger log = LoggerFactory.getLogger(PQLSearch.class);
    public static final String FIELD_STAKEHOLDERS = "stakeholders";
    public static final String FIELD_LEAD = "lead";
    public static final String FIELD_STATUS = "status";
    private static final List<String> VALID_FIELDS = Arrays.asList("lead", "stakeholders", "status");
    private final List<String> fields;

    public ProjectrakPQL() {
        this.fields = Collections.emptyList();
    }

    public ProjectrakPQL(String targetField) {
        if (!VALID_FIELDS.contains(targetField)) {
            throw new IllegalArgumentException("Target field not valid: " + targetField);
        }
        this.fields = Arrays.asList("key", targetField);
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        if (gadget != null && gadget.getConfig() != null && gadget.getConfig().getOtherConfig() == null) {
            gadget.getConfig().addOtherConfig("PQL", "");
        }
        ProjectrakPQLConfig config = GadgetRequesterUtils.getConfig(gadget, ProjectrakPQLConfig.class);
        try {
            List<Integer> indexedFields = this.fields.isEmpty() ? this.getFieldsIds() : this.getFieldsIds(this.fields);
            List<Map> data = this.connector.execPQL(config.getPQL(), indexedFields, true);
            HashMap<String, List<Map>> response = new HashMap<String, List<Map>>();
            response.put("projects", data);
            return response;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Something went wrong", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

