/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk;

import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.JSMMultiproject;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.JSMDataUtil2;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.serviceDesk.utils.configs.AgentWorkloadConfig;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.model.Field;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.GadgetRequesterUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JiraDataUtils;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentWorkload
extends JSMMultiproject {
    private static final Logger log = LoggerFactory.getLogger(AgentWorkload.class);
    private static final List DEFAULT_FIELDS = Arrays.asList("resolution", "assignee", "status");
    private String groupByField = "assignee";

    void setTargetGroupByField(String groupByField) {
        if (groupByField != null && !groupByField.isEmpty()) {
            this.groupByField = groupByField;
        }
        log.warn(String.format("Invalid value for AgentWorkload gadget - %s", groupByField));
    }

    protected List getIssues(AgentWorkloadConfig config, List<Field> fields, String dateStr, String queuesJql) {
        Field groupByFieldDefinition = fields.stream().filter(f -> f.getId().equals(this.groupByField)).findFirst().orElse(null);
        if (groupByFieldDefinition == null) {
            throw new DhUserException(400, "INVALID_FIELD", "Group by field " + this.groupByField + " not found");
        }
        String groupByFieldClauseName = (String)((List)groupByFieldDefinition.getOtherFields().get("clauseNames")).get(0);
        List _issues = config.getSlaFields().stream().map(slaField -> {
            List<Field> matchingFields = JiraDataUtils.getFieldsWithSameName(String.valueOf(slaField.get(0)), fields);
            String jqlParam = matchingFields.stream().map(matchingField -> {
                String name = (String)((List)matchingField.getOtherFields().get("clauseNames")).get(0);
                String _jql = String.format("%s = completed() AND updatedDate >= '%s' AND '%s' IS NOT NULL AND (%s)", name, dateStr, groupByFieldClauseName, queuesJql);
                return _jql;
            }).collect(Collectors.joining(" OR "));
            List<String> requiredFields = matchingFields.stream().map(matchingField -> matchingField.getKey() != null ? matchingField.getKey() : matchingField.getId()).collect(Collectors.toList());
            requiredFields.add(this.groupByField);
            return this.execJQLwithFilterFields(jqlParam, requiredFields, fields, null, null, null, null).getIssues();
        }).collect(Collectors.toList());
        return _issues;
    }

    protected void setSlaIssues(AgentWorkloadConfig config, Map issues, List _issues) {
        int i = 0;
        for (List<String> slaField : config.getSlaFields()) {
            issues.put(slaField.get(0), _issues.get(i));
            ++i;
        }
    }

    public Object getWorkLoadData(AgentWorkloadConfig config) {
        try {
            HashMap result = new HashMap();
            HashMap<String, List> issues = new HashMap<String, List>();
            ArrayList<String> requiredFields = new ArrayList<String>(DEFAULT_FIELDS);
            if (this.groupByField != null && !this.groupByField.isEmpty()) {
                requiredFields.add(this.groupByField);
            }
            List<Field> fields = this.getFields();
            Map jqlQueuesMap = this.getJqlQueues(config);
            String dateStr = JSMDataUtil2.getDateAsString(config.getTimeRange());
            List _issues = this.getIssues(config, fields, dateStr, (String)jqlQueuesMap.get("jql"));
            this.setSlaIssues(config, issues, _issues);
            List totals = this.getQueueIssuesByTimeRange(dateStr, (String)jqlQueuesMap.get("jql"), requiredFields, fields);
            issues.put("totals", totals);
            result.put("issues", issues);
            result.put("queues", jqlQueuesMap.get("queues"));
            return result;
        }
        catch (DhUserException userException) {
            throw userException;
        }
        catch (BadRequestToSourceException badRequestException) {
            throw badRequestException;
        }
        catch (Exception e) {
            log.error("Problems getting workload data", (Throwable)e);
            throw new DhUserException(500, "WORKLOAD_DATA_ERROR", "Problems getting data: " + e.getMessage());
        }
    }

    @Override
    public Object getData(GadgetModel gadget, List<String> extraParams) {
        AgentWorkloadConfig config = GadgetRequesterUtils.getConfig(gadget, AgentWorkloadConfig.class);
        return this.getWorkLoadData(config);
    }
}

