/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.bigpicture;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.BigPictureConnector;
import com.roninpixels.dashboardhub.controllers.bigpicture.BigPictureController;
import com.roninpixels.dashboardhub.controllers.bigpicture.BigPictureControllerFactory;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequester;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapperImpl;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

public abstract class BigPictureBaseGadgetRequester
implements GadgetRequester {
    private static final Logger log = LoggerFactory.getLogger(BigPictureBaseGadgetRequester.class);
    protected DHObjectMapper mapper = new DHObjectMapperImpl();
    @Inject
    private ConnectorsProvider provider;
    @Inject
    private BeanFactory beanFactory;
    @Inject
    private BigPictureControllerFactory bigPictureControllerFactory;
    protected BigPictureConnector bipPictureConnector;
    protected BigPictureController bigPictureController;
    protected Map context;

    @Override
    public void init(DatasourceModel datasource, Map context) {
        this.bipPictureConnector = (BigPictureConnector)this.provider.getConnector(datasource);
        if (this.bipPictureConnector == null) {
            throw new IllegalArgumentException("Datasource is not valid for gadget requester: " + this.getClass().getAnnotation(Component.class));
        }
        this.bigPictureController = this.bigPictureControllerFactory.create(this.bipPictureConnector);
        this.context = context;
    }

    protected void checkStatus(ResponseEntity<?> response) throws BadRequestToSourceException {
        if (response.getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
    }

    protected <T> T checkStatusAndParse(ResponseEntity<String> response, Class<T> clazz) throws Exception {
        this.checkStatus(response);
        return this.mapper.readValue((String)response.getBody(), clazz);
    }
}

