/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters;

import com.roninpixels.dashboardhub.controllers.DatasourceRunAsOwnerSettingsController;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetsRequesterController;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetRequesterException;
import com.roninpixels.dashboardhub.gadgetsRequesters.GadgetsRequestService;
import com.roninpixels.dashboardhub.gadgetsRequesters.SecureGadgetDefProviderSrv;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.GadgetRequestModel;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GadgetsRequestServiceImpl
implements GadgetsRequestService {
    private static final Logger log = LoggerFactory.getLogger(GadgetsRequestServiceImpl.class);
    @Inject
    private GadgetsRequesterController controller;
    @Inject
    private DashboardHubPluginManager dhLicenseManager;
    @Inject
    private SecureGadgetDefProviderSrv securityCheckerSrv;
    @Inject
    private DatasourceRunAsOwnerSettingsController datasourceRunAsOwnerSettingsController;

    private void updateRunAsStrategy(GadgetModel gadget) {
        DatasourceModel ds = gadget.getConfig().getDatasource();
        Map<String, Object> otherConfig = gadget.getConfig().getOtherConfig();
        if (this.datasourceRunAsOwnerSettingsController.isRunAsOwnerRestricted() && DatasourcesUtil.canRunAsViewer(ds) || otherConfig != null && "viewer".equals(otherConfig.get("runAs")) && DatasourcesUtil.canRunAsViewer(ds)) {
            DsOptionsModel options = ds.getOptions();
            if (options == null) {
                options = new DsOptionsModel();
                ds.setOptions(options);
            }
            options.addOtherConfig("runAs", "viewer");
        }
    }

    @Override
    public Response doRequest(GadgetRequestModel gadgetRequest) {
        try {
            GadgetModel gadget = this.securityCheckerSrv.checkAndGetStoredGadget(gadgetRequest);
            return this.doRequest(gadget, gadgetRequest.getExtraParams(), Collections.emptyMap());
        }
        catch (GadgetRequesterException gre) {
            log.error("Problems with gadget request", (Throwable)gre);
            return ResponseBuilder.createErrorFrom(gre);
        }
    }

    @Override
    public Response doRequest(GadgetModel gadget, List<String> extraParams, Map context) {
        try {
            if (!this.dhLicenseManager.isLicensed()) {
                throw new GadgetRequesterException("License is not valid", 400);
            }
            if (gadget == null) {
                throw new GadgetRequesterException("INVALID_GADGET", 400);
            }
            this.updateRunAsStrategy(gadget);
            DatasourceModel ds = gadget.getConfig().getDatasource();
            Object data = this.controller.getDataFor(gadget, ds, extraParams, context);
            return ResponseBuilder.ok(data).build();
        }
        catch (BadRequestToSourceException bre) {
            log.error("Request problems for a gadget request");
            return ResponseBuilder.createErrorFrom(bre);
        }
        catch (GadgetRequesterException gre) {
            log.error("Problems with gadget request", (Throwable)gre);
            return ResponseBuilder.createErrorFrom(gre);
        }
        catch (Exception e) {
            log.error("Problems with gadget request", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

