/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.activeobjects.tx.Transactional;
import com.roninpixels.dashboardhub.controllers.UserTemplateController;
import com.roninpixels.dashboardhub.store.UserTemplateRepository;
import com.roninpixels.dashboardhub.web.models.UserTemplateModel;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class UserTemplateControllerImpl
implements UserTemplateController {
    private static final Logger log = LoggerFactory.getLogger(UserTemplateControllerImpl.class);
    @Inject
    private UserTemplateRepository userTemplateRepository;

    @Override
    public List<UserTemplateModel> getUserTemplates(boolean includeDisabled) {
        log.debug(String.format("Getting user templates includeDisabled: %s", includeDisabled));
        try {
            return this.userTemplateRepository.getUserTemplates(includeDisabled);
        }
        catch (Exception e) {
            log.error(String.format("Error getting user templates", new Object[0]), (Throwable)e);
            throw new RuntimeException("Failed to get user templates", e);
        }
    }

    @Override
    public UserTemplateModel getUserTemplate(String templateId) {
        log.debug(String.format("Getting user template with ID: %s", templateId));
        try {
            return this.userTemplateRepository.getUserTemplate(templateId);
        }
        catch (Exception e) {
            log.error(String.format("Error getting user template with ID: %s", templateId), (Throwable)e);
            throw new RuntimeException("Failed to get user template", e);
        }
    }

    @Override
    public UserTemplateModel createUserTemplate(UserTemplateModel template) {
        log.debug(String.format("Creating user template with title: %s", template.getTitle()));
        try {
            if (template.getTitle() == null || template.getTitle().trim().isEmpty()) {
                throw new IllegalArgumentException("Template title is required");
            }
            if (template.getDescriptor() == null || template.getDescriptor().trim().isEmpty()) {
                throw new IllegalArgumentException("Template descriptor is required");
            }
            return this.userTemplateRepository.createUserTemplate(template);
        }
        catch (Exception e) {
            log.error(String.format("Error creating user template", new Object[0]), (Throwable)e);
            throw new RuntimeException("Failed to create user template", e);
        }
    }

    @Override
    public UserTemplateModel updateUserTemplate(String templateId, UserTemplateModel template) {
        log.debug(String.format("Updating user template with ID: %s", templateId));
        try {
            if (template.getTitle() == null || template.getTitle().trim().isEmpty()) {
                throw new IllegalArgumentException("Template title is required");
            }
            if (template.getDescriptor() == null || template.getDescriptor().trim().isEmpty()) {
                throw new IllegalArgumentException("Template descriptor is required");
            }
            UserTemplateModel updatedTemplate = this.userTemplateRepository.updateUserTemplate(templateId, template);
            if (updatedTemplate == null) {
                throw new RuntimeException("Template not found with ID: " + templateId);
            }
            return updatedTemplate;
        }
        catch (Exception e) {
            log.error(String.format("Error updating user template with ID: %s", templateId), (Throwable)e);
            throw new RuntimeException("Failed to update user template", e);
        }
    }

    @Override
    public UserTemplateModel deleteUserTemplate(String templateId) {
        log.debug(String.format("Deleting user template with ID: %s", templateId));
        try {
            UserTemplateModel deletedTemplate = this.userTemplateRepository.deleteUserTemplate(templateId);
            if (deletedTemplate == null) {
                throw new RuntimeException("Template not found with ID: " + templateId);
            }
            return deletedTemplate;
        }
        catch (Exception e) {
            log.error(String.format("Error deleting user template with ID: %s", templateId), (Throwable)e);
            throw new RuntimeException("Failed to delete user template", e);
        }
    }
}

