/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.roninpixels.dashboardhub.controllers.BoardActionsValidator;
import com.roninpixels.dashboardhub.controllers.PublicLinkManagementController;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetsValidationController;
import com.roninpixels.dashboardhub.exceptions.BoardValidationException;
import com.roninpixels.dashboardhub.gadgetsValidators.ValidationResponse;
import com.roninpixels.dashboardhub.permissions.AccessManager;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import java.util.Collections;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BoardActionsValidatorImpl
implements BoardActionsValidator {
    private static final Logger log = LoggerFactory.getLogger(BoardActionsValidatorImpl.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private GadgetsValidationController gadgetsValidationController;
    @Inject
    private PublicLinkManagementController publicLinkManagementController;
    @Inject
    private AccessManager boardAccessManager;

    private void evaluate(ValidationResponse validation) {
        if (!validation.isValid()) {
            log.error(validation.getError());
            throw new BoardValidationException(validation.getError());
        }
    }

    @Override
    public void validateUpdate(BoardModel newBoard, BoardModel oldBoard) {
        ValidationResponse validation = new ValidationResponse(true);
        if (!this.boardAccessManager.canUserLoggedInEdit(oldBoard)) {
            validation = new ValidationResponse(false, Collections.singletonList("You are not allowed to delete the dashboard"));
        }
        if (newBoard.getSharing() != null && Boolean.TRUE.equals(newBoard.getSharing().getPublic()) && !newBoard.getSharing().equals(oldBoard.getSharing()) && !this.publicLinkManagementController.canUserCreatePublicLinks(this.dhUserService.getLoggedInUserKey())) {
            validation = new ValidationResponse(false, Collections.singletonList("You are not allowed to update the public sharing configuration"));
        }
        if (validation.isValid()) {
            validation = this.gadgetsValidationController.validateDataFor(newBoard, oldBoard);
        }
        this.evaluate(validation);
    }

    @Override
    public void validateCreate(BoardModel newBoard) {
        ValidationResponse validation = new ValidationResponse(true);
        if (newBoard.getSharing() != null && !this.publicLinkManagementController.canUserCreatePublicLinks(this.dhUserService.getLoggedInUserKey())) {
            validation = new ValidationResponse(false, Collections.singletonList("You are not allowed to create a dashboard with a public sharing configuration"));
        }
        if (validation.isValid()) {
            validation = this.gadgetsValidationController.validateDataFor(newBoard, null);
        }
        this.evaluate(validation);
    }

    @Override
    public void validateClone(BoardModel board) {
        ValidationResponse validation = new ValidationResponse(true);
        if (board.getSharing() != null && !this.publicLinkManagementController.canUserCreatePublicLinks(this.dhUserService.getLoggedInUserKey())) {
            validation = new ValidationResponse(false, Collections.singletonList("You are not allowed to clone a dashboard with a public sharing configuration"));
        }
        if (validation.isValid()) {
            validation = this.gadgetsValidationController.validateDataForCloned(board);
        }
        this.evaluate(validation);
    }

    @Override
    public void validateDelete(BoardModel board) {
        ValidationResponse validation = new ValidationResponse(true);
        if (!this.boardAccessManager.canUserLoggedInEdit(board) && !this.dhUserService.isLoggedUserAdmin().booleanValue()) {
            validation = new ValidationResponse(false, Collections.singletonList("You are not allowed to delete the dashboard"));
        }
        this.evaluate(validation);
    }
}

