/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.server.functions;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.configs.JiraIntegrationProperties;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.ExecJQLFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;

public class ExecJQLServerFunc
extends ExecJQLFunc {
    static final String PATH = "/rest/api/2/search";

    public ExecJQLServerFunc(ServerConnector connector, JiraIntegrationProperties jiraProps) {
        super(connector, jiraProps);
    }

    @Override
    protected JQLResponse executeSearchStrategy(Map<String, Object> mParams, int limitIssues) throws Exception {
        int tmpPageSize = (Integer)mParams.getOrDefault("maxResults", 100);
        if (tmpPageSize < 0 || tmpPageSize > 100) {
            tmpPageSize = 100;
        }
        int pageSize = tmpPageSize;
        mParams.put("maxResults", pageSize);
        mParams.putIfAbsent("startAt", 0);
        List issues = new LinkedList<Map>();
        ResponseEntity<JQLResponse> response = this.connector.executeRequest(Request.MethodType.POST, PATH, mParams, JQLResponse.class);
        ResponseChecker.checkStatus(response);
        JQLResponse jqlResponse = (JQLResponse)response.getBody();
        if (jqlResponse.getIssues().size() < limitIssues && jqlResponse.getTotal() > pageSize) {
            int remainingIssues = Math.min(jqlResponse.getTotal(), limitIssues) - jqlResponse.getIssues().size();
            int pendingJobs = (int)Math.ceil((double)remainingIssues / (double)pageSize);
            LinkedList<HashMap<String, Object>> jobs = new LinkedList<HashMap<String, Object>>();
            for (int i = 0; i < pendingJobs; ++i) {
                HashMap<String, Object> localParams = new HashMap<String, Object>(mParams);
                localParams.put("startAt", pageSize * (i + 1));
                jobs.add(localParams);
            }
            ForkJoinPool customThreadPool = new ForkJoinPool(this.PARALLEL_REQUESTS);
            issues = (List)((ForkJoinTask)customThreadPool.submit(() -> jobs.parallelStream().map(localParams -> {
                ResponseEntity<JQLResponse> localResponse = this.connector.executeRequest(Request.MethodType.POST, PATH, (Map<String, ?>)localParams, JQLResponse.class);
                ResponseChecker.checkStatus(localResponse);
                JQLResponse result = (JQLResponse)localResponse.getBody();
                return result.getIssues();
            }).flatMap(localIssues -> localIssues.stream()).collect(Collectors.toList()))).get();
            customThreadPool.shutdown();
        }
        issues.addAll(0, jqlResponse.getIssues());
        jqlResponse.setIssues(issues);
        return jqlResponse;
    }
}

