/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions.AsyncRequest;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.ApproxCountResponse;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.ParsedJqlQueries;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.ParsedJqlQuery;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class ValidateJqlFunc {
    static final String PATH_PARSE = "/rest/api/3/jql/parse";
    private static final Logger log = LoggerFactory.getLogger(ValidateJqlFunc.class);
    private final ServerConnector connector;

    public ValidateJqlFunc(ServerConnector connector) {
        this.connector = connector;
    }

    public ResponseEntity<String> jqlValidation(String jql, Map<String, ?> extraOpts) {
        String[] errors;
        ParsedJqlQueries parsedJqlQueries;
        ParsedJqlQuery[] queries;
        CompletableFuture<ApproxCountResponse> requestCount = AsyncRequest.approxCount(this.connector, jql);
        String validation = (String)extraOpts.get("validateQuery");
        if (("strict".equals(validation) || "warn".equals(validation)) && (queries = (parsedJqlQueries = (ParsedJqlQueries)this.connector.executeRequest(Request.MethodType.POST, PATH_PARSE, Collections.singletonMap("validation", validation), Collections.emptyMap(), this.miniJson("queries", this.asArray(jql)), ParsedJqlQueries.class).getBody()).getQueries()) != null && queries.length > 0 && (errors = queries[0].getErrors()) != null && errors.length > 0) {
            String msg = this.miniJson("errorMessages", this.asArray(errors));
            return new ResponseEntity((Object)msg, HttpStatus.BAD_REQUEST);
        }
        int total = 0;
        try {
            total = requestCount.get().getCount();
        }
        catch (Exception e) {
            log.warn("Failed to get approximate count of issues.", (Throwable)e);
        }
        String msg = this.miniJson("total", total);
        return new ResponseEntity((Object)msg, HttpStatus.OK);
    }

    private String escape(String value) {
        return value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
    }

    String asArray(String ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        CharSequence[] escaped = (String[])Arrays.stream(values).map(this::escape).toArray(String[]::new);
        return "[\"" + String.join((CharSequence)"\",\"", escaped) + "\"]";
    }

    String miniJson(String key, Object value) {
        return "{\"" + key + "\": " + value + "}";
    }
}

