/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.configs.JiraIntegrationProperties;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.jira.cloud.functions.AsyncRequest;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.ApproxCountResponse;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.ExecJQLFunc;
import com.roninpixels.dashboardhub.connectors.impl.jira.common.functions.JQLResponse;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;

public class ExecJQLCloudFunc
extends ExecJQLFunc {
    static final String PATH_BULKFETCH = "/rest/api/3/issue/bulkfetch";

    public ExecJQLCloudFunc(ServerConnector connector, JiraIntegrationProperties jiraProps) {
        super(connector, jiraProps);
    }

    @Override
    protected JQLResponse executeSearchStrategy(Map<String, Object> params, int limitIssues) throws Exception {
        CompletableFuture<JQLResponse> requestIds;
        String sanitizedJql = JqlUtils.sanitizeJql(params.get("jql"));
        Map<String, Object> paramsFields = this.toSearchParams(params);
        paramsFields.put("maxResults", Math.min(limitIssues, 100));
        paramsFields.put("jql", sanitizedJql);
        CompletableFuture<JQLResponse> requestFields = AsyncRequest.search(this.connector, paramsFields);
        HashMap<String, Object> paramsIds = new HashMap<String, Object>();
        if (limitIssues <= 100) {
            requestIds = null;
        } else {
            paramsIds.put("maxResults", Math.min(limitIssues, 5000));
            paramsIds.put("fields", Arrays.asList("id"));
            paramsIds.put("jql", sanitizedJql);
            requestIds = AsyncRequest.search(this.connector, paramsIds);
        }
        JQLResponse responseFields = requestFields.get();
        int issuesCountFields = this.countIssues(responseFields);
        responseFields.setTotal(issuesCountFields);
        if (issuesCountFields == limitIssues || issuesCountFields < 100 || StringUtils.isBlank((CharSequence)responseFields.getNextPageToken())) {
            return responseFields;
        }
        CompletableFuture<ApproxCountResponse> requestCount = AsyncRequest.approxCount(this.connector, (String)params.get("jql"));
        ArrayList<Map> allIssues = new ArrayList<Map>(responseFields.getIssues());
        int startWithIdsAt = issuesCountFields;
        while (requestIds != null) {
            JQLResponse responseIds = requestIds.get();
            int issuesCountIds = this.countIssues(responseIds);
            List<String[]> jobs = this.createJobs(responseIds.getIssues(), startWithIdsAt);
            if (jobs.size() == 0) break;
            String nextPageToken = responseIds.getNextPageToken();
            if (allIssues.size() + issuesCountIds < limitIssues && !StringUtils.isBlank((CharSequence)nextPageToken)) {
                paramsIds.put("nextPageToken", nextPageToken);
                startWithIdsAt = 0;
                requestIds = AsyncRequest.search(this.connector, paramsIds);
            } else {
                requestIds = null;
            }
            ForkJoinPool customThreadPool = new ForkJoinPool(this.PARALLEL_REQUESTS);
            List issues = (List)((ForkJoinTask)customThreadPool.submit(() -> jobs.parallelStream().map(job -> this.execBulkFetchRequest(params, (String[])job).getIssues()).flatMap(localIssues -> localIssues.stream()).collect(Collectors.toList()))).get();
            allIssues.addAll(issues);
            customThreadPool.shutdown();
        }
        responseFields.setIssues(allIssues);
        responseFields.setTotal(allIssues.size() < limitIssues ? allIssues.size() : requestCount.get().getCount());
        return responseFields;
    }

    Map<String, Object> toSearchParams(Map<String, Object> params) {
        Map<String, Object> cloudParams = this.extractParams(params, "fields", "properties");
        if (params.containsKey("expand")) {
            String s = String.join((CharSequence)",", (List)params.get("expand"));
            cloudParams.put("expand", s);
        }
        return cloudParams;
    }

    private List<Map> sortByIds(String[] ids, List<Map> issues) {
        Map<String, Map> issuesById = issues.stream().collect(Collectors.toMap(issue -> (String)issue.get("id"), issue -> issue));
        return Arrays.stream(ids).map(issuesById::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private JQLResponse execBulkFetchRequest(Map<String, Object> params, String[] ids) {
        assert (ids.length <= 100);
        Map<String, Object> paramsBulk = this.extractParams(params, "fields", "properties", "expand");
        paramsBulk.put("issueIdsOrKeys", Arrays.asList(ids));
        ResponseEntity<JQLResponse> response = this.connector.executeRequest(Request.MethodType.POST, PATH_BULKFETCH, paramsBulk, JQLResponse.class);
        ResponseChecker.checkStatus(response);
        JQLResponse jqlResponse = (JQLResponse)response.getBody();
        jqlResponse.setIssues(this.sortByIds(ids, jqlResponse.getIssues()));
        return jqlResponse;
    }

    private Map<String, Object> extractParams(Map<String, Object> params, String ... keys) {
        HashMap<String, Object> extractedParams = new HashMap<String, Object>();
        Arrays.stream(keys).forEach(k -> {
            if (params.containsKey(k)) {
                extractedParams.put((String)k, params.get(k));
            }
        });
        return extractedParams;
    }

    private int countIssues(JQLResponse jqlResponse) {
        return jqlResponse.getIssues() != null ? jqlResponse.getIssues().size() : 0;
    }

    private List<String[]> createJobs(List<Map> issues, int startAt) {
        return this.createJobs(issues, startAt, 100);
    }

    List<String[]> createJobs(List<Map> issues, int startAt, int pageSize) {
        ArrayList<String[]> jobs = new ArrayList<String[]>();
        if (issues != null && issues.size() > startAt) {
            String[] allIds = issues.stream().map(i -> i.get("id")).collect(Collectors.toList()).toArray(new String[issues.size()]);
            for (int i2 = startAt; i2 < allIds.length; i2 += pageSize) {
                jobs.add(Arrays.copyOfRange(allIds, i2, Math.min(i2 + pageSize, allIds.length)));
            }
        }
        return jobs;
    }
}

