/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.server.functions;

import com.roninpixels.dashboardhub.connectors.impl.confluence.server.ConfluenceRestConnector;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class IsValidFunc {
    private static final Logger log = LoggerFactory.getLogger(IsValidFunc.class);
    private final ConfluenceRestConnector confConnector;
    private final ServerConnector connector;

    public IsValidFunc(ConfluenceRestConnector confConnector, ServerConnector connector) {
        this.confConnector = confConnector;
        this.connector = connector;
    }

    void checkMinVersion() throws Exception {
        ResponseEntity<String> response = this.confConnector.serverInfo();
        Map data = ResponseChecker.checkStatusAndParse(response, Map.class);
        int buildNumber = (Integer)data.get("buildNumber");
        if (buildNumber < 7901) {
            String msg = String.format("The Confluence server/dc '%s' is not compatible. Found version: %d (MIN value: %d)", this.confConnector.getURL(), buildNumber, 7901);
            throw new DhUserException(400, "INCOMPATIBLE_VERSION", msg);
        }
    }

    public boolean isValid() {
        try {
            this.checkMinVersion();
            return true;
        }
        catch (BadRequestToSourceException dhe) {
            throw dhe;
        }
        catch (Exception e) {
            log.error("Problems getting server info. URL base: " + this.confConnector.getURL(), (Throwable)e);
            return false;
        }
    }
}

