/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.server.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;

public class GetPopularPagesFunc {
    static final String PATH = "/rest/popular/1/stream/content";
    private ServerConnector mConnector;

    public GetPopularPagesFunc(ServerConnector connector) {
        this.mConnector = connector;
    }

    public List<Map> exec(int maxResults, int days) {
        LinkedList<Map> pages = new LinkedList<Map>();
        int max = Math.min(maxResults, 100);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("days", "" + days);
        boolean hasMore = true;
        while (hasMore && pages.size() < max) {
            ResponseEntity<Map> response = this.mConnector.executeRequest(PATH, params, Map.class);
            ResponseChecker.checkStatus(response);
            Map data = (Map)response.getBody();
            List currentPages = (List)data.get("streamItems");
            pages.addAll(currentPages);
            Integer nextPageOffset = (Integer)data.get("nextPageOffset");
            hasMore = nextPageOffset != null;
            if (!hasMore) continue;
            params.put("nextPageOffset", nextPageOffset.toString());
        }
        return pages;
    }
}

