/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.confluence.cloud;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.ExecCQLCloudFunc;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.GetBlogSpotCloudV2Func;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.GetInlineTasksCloudV2Func;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.GetPageCloudV2Func;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.GetSpacesCloudV2Func;
import com.roninpixels.dashboardhub.connectors.impl.confluence.cloud.functions.searchCQLCloudFunc;
import com.roninpixels.dashboardhub.connectors.impl.confluence.common.functions.SearchUsersFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ConfluenceConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.CustomReportConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ImageProvider;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class ConfluenceRestCloudConnector
implements ConfluenceConnector,
ImageProvider,
CustomReportConnector {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceRestCloudConnector.class);
    public static final String REST_API_USER_CURRENT = "/rest/api/user/current";
    public static final String REST_API_CONTENT_S = "/rest/api/content/%s";
    public static final String REST_API_USER_DETAIL = "/rest/api/user?accountId=%s";
    private ServerConnector connector;

    public ConfluenceRestCloudConnector(ServerConnector connector) {
        this.connector = connector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public boolean isValid() {
        ResponseEntity<String> response = this.me();
        ResponseChecker.checkStatus(response);
        return true;
    }

    @Override
    public ResponseEntity<List> getSpaces(Map params, Map options) {
        return new GetSpacesCloudV2Func(this.connector).getSpaces(params, options);
    }

    @Override
    public List execCQL(Map params, Map<String, Object> options) {
        return new ExecCQLCloudFunc(this.connector).execCQL(params, options);
    }

    @Override
    public List searchCQL(Map params, Map<String, Object> options) {
        String searchTerm = (String)params.get("searchTerm");
        String cql = searchTerm == null || searchTerm.trim().equals("") ? "type = 'space'" : "title ~ '" + params.get("searchTerm") + "*' AND type = 'space'";
        params.put("cql", cql);
        if (params.containsKey("searchTerm")) {
            params.remove("searchTerm");
        }
        return new searchCQLCloudFunc(this.connector).execCQL(params, options);
    }

    @Override
    public List getInlineTasks(Map params, Map options) throws IOException {
        return new GetInlineTasksCloudV2Func(this.connector).getTasks(params);
    }

    @Override
    public List getUsersByUsername(List<String> users) {
        return users.stream().map(username -> {
            String path = String.format(REST_API_USER_DETAIL, username);
            ResponseEntity<Map> responseEntity = this.connector.executeRequest(path, null, Map.class);
            return responseEntity.getStatusCode().value() < 400 ? (Map)responseEntity.getBody() : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public ResponseEntity<String> serverInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResponseEntity<String> me() {
        return this.connector.executeRequest(REST_API_USER_CURRENT);
    }

    @Override
    @Deprecated
    public Map getContent(String contentId) {
        String path = String.format(REST_API_CONTENT_S, contentId);
        ResponseEntity<Map> responseEntity = this.connector.executeRequest(path, null, Map.class);
        ResponseChecker.checkStatus(responseEntity);
        return (Map)responseEntity.getBody();
    }

    @Override
    public List<String> getTaskUsernames(Map task) {
        return GetInlineTasksCloudV2Func.getUsersAssigned(task);
    }

    @Override
    public List<Map> formatTasks(List<Map> tasks, List<Map> users) {
        List pageIds = tasks.stream().map(task -> (String)task.get("pageId")).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map params = Collections.singletonMap("id", pageIds);
        Map<String, Boolean> options = Collections.singletonMap("all", true);
        List<Map> pages = new GetPageCloudV2Func(this.connector).getPages(params, options);
        List blogSpotsIds = tasks.stream().map(task -> (String)task.get("blogPostId")).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map paramsBlogSpots = Collections.singletonMap("id", blogSpotsIds);
        List<Map> blogSpots = new GetBlogSpotCloudV2Func(this.connector).getBlogSpots(paramsBlogSpots, options);
        List<Map> contents = Stream.concat(pages.stream(), blogSpots.stream()).map(page -> {
            LinkedHashMap newContent = new LinkedHashMap();
            newContent.put("id", page.get("id"));
            newContent.put("title", page.get("title"));
            return newContent;
        }).collect(Collectors.toList());
        List taskIds = tasks.stream().map(task -> (String)task.get("id")).collect(Collectors.toList());
        HashMap<String, Object> tasksParams = new HashMap<String, Object>();
        tasksParams.put("body-format", "storage");
        tasksParams.put("task-id", taskIds);
        List<Map> tasksWithStorageBody = new GetInlineTasksCloudV2Func(this.connector).getTasks(tasksParams);
        tasks.stream().forEach(task -> {
            String taskId = (String)task.get("id");
            Map taskWithBody = tasksWithStorageBody.stream().filter(t -> taskId.equals(t.get("id"))).findAny().orElse(null);
            if (taskWithBody != null) {
                Map bodyStorage = (Map)((Map)taskWithBody.get("body")).get("storage");
                ((Map)task.get("body")).put("storage", bodyStorage);
            }
        });
        Map<Object, Map> userMap = users.stream().collect(Collectors.toMap(user -> user.get("accountId"), user -> user));
        Map inlineUsersTaskMap = GetInlineTasksCloudV2Func.getInlineUsersTaskMap(tasks);
        return GetInlineTasksCloudV2Func.formatTasks(tasks, inlineUsersTaskMap, userMap, contents);
    }

    @Override
    public List<Map> getUsersAssignedTasks(List<Map> tasks) {
        new GetInlineTasksCloudV2Func(this.connector);
        List<String> accountIds = GetInlineTasksCloudV2Func.getUsersAssignedTasks(tasks);
        return this.getUsersByUsername(accountIds);
    }

    @Override
    public Map getUserByKey(String key) {
        throw new RuntimeException("Method 'getUserByKey()' is not supported by ConfluenceRestCloudConnector");
    }

    @Override
    public Map getUserByUsername(String username) {
        throw new RuntimeException("Method 'getUserByUsername()' is not supported by ConfluenceRestCloudConnector");
    }

    @Override
    public List<Map> getUsersByUserKeys(List<String> userKeys) {
        throw new RuntimeException("Method 'getUsersByUserKeys()' is not supported by ConfluenceRestCloudConnector");
    }

    @Override
    public List<Map> getGroupsByGroupNames(List<String> groupNames) {
        throw new RuntimeException("Method 'getGroupsByGroupNames()' is not supported by ConfluenceRestCloudConnector");
    }

    @Override
    public List<Map> searchUsers(String searchTerm, int maxResults) {
        return new SearchUsersFunc(this.connector).searchUsers(searchTerm, maxResults);
    }

    @Override
    public List<Map> getPopularPages(int maxResults, int days) {
        throw new RuntimeException("Method 'getPopularPages()' is not supported by ConfluenceRestCloudConnector");
    }

    @Override
    public ResponseEntity<InputStream> getImage(String path) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "image/*");
        headers.put("encoding", "binary");
        ResponseEntity<InputStream> response = this.connector.executeRequest(Request.MethodType.GET, path, null, headers, InputStream.class);
        return response;
    }

    @Override
    public ResponseEntity executeRequest(CustomReportConnector.RequestConfig rConfig) {
        return this.connector.executeRequest(rConfig.getMethod(), rConfig.getUrl(), (Map<String, ?>)rConfig.getParams(), rConfig.getHeaders(), rConfig.getBody(), InputStream.class);
    }
}

