/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.jira.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.JiraConnector;
import com.roninpixels.dashboardhub.web.rest.base.jira.api.GenericJiraEndpoint;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class StatusEndpoint {
    private static final Logger log = LoggerFactory.getLogger(StatusEndpoint.class);
    @Inject
    private ConnectorsProvider connProvider;

    public Response getStatus(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ResponseEntity<String> res = jira.getStatuses();
            return GenericJiraEndpoint.generateResponse(res, "status");
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting status values");
        }
    }

    public Response getStatusCategory(@NotNull @HeaderParam(value="datasourceinfo") String datasourceinfo) {
        try {
            JiraConnector jira = (JiraConnector)this.connProvider.getConnectorFromEncryptedDs(datasourceinfo);
            ResponseEntity<String> res = jira.getStatusCategory();
            return GenericJiraEndpoint.generateResponse(res, "statusCategory");
        }
        catch (Exception e) {
            return ResponseBuilder.handleApiResponse(e, "Problems getting status categories values");
        }
    }
}

