/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dilbert.api;

import com.roninpixels.dashboardhub.connectors.ConnectorsProvider;
import com.roninpixels.dashboardhub.connectors.interfaces.DilbertConnector;
import com.roninpixels.dashboardhub.exceptions.BadRequestToSourceException;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.http.ResponseEntity;

@Path(value="/dilbert/feed")
public class DilbertEndpoint {
    @Inject
    private ConnectorsProvider connProvider;

    private DilbertConnector getConnector() {
        DatasourceModel ds = new DatasourceModel();
        ds.setProduct(DilbertConnector.PRODUCT);
        return (DilbertConnector)this.connProvider.getConnector(ds);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        Map<String, ArrayList<Object>> assets = null;
        try {
            ResponseEntity<Map> feedResponse = this.getConnector().getJsonFeed();
            assets = this.checkStatusAndParse(feedResponse);
        }
        catch (Exception e) {
            assets = new HashMap();
            assets.put("assets", new ArrayList());
        }
        return ResponseBuilder.ok(assets).build();
    }

    protected Map checkStatusAndParse(ResponseEntity<Map> response) throws Exception {
        if (response.getStatusCode().value() >= 400) {
            throw new BadRequestToSourceException(response);
        }
        Map feed = (Map)response.getBody();
        return (Map)((List)feed.get("features")).get(0);
    }
}

