/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.web.rest.base.dashboardHub.management;

import com.roninpixels.dashboardhub.config.frontedModel.GenericRestrictionSettingsModel;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.controllers.DatasourceRunAsOwnerSettingsController;
import com.roninpixels.dashboardhub.controllers.DatasourceSettingsController;
import com.roninpixels.dashboardhub.controllers.DatasourceSharingSettingsController;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.rest.base.dashboardHub.management.DatasourcesGlobalSettingsMsg;
import com.roninpixels.dashboardhub.web.utils.ResponseBuilder;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourcesEndpoint {
    private static final Logger log = LoggerFactory.getLogger(DatasourcesEndpoint.class);
    @Inject
    private AccessManagementController accessManagementController;
    @Inject
    private DatasourceSettingsController datasourceSettingsController;
    @Inject
    private DatasourceRunAsOwnerSettingsController datasourceRunAsOwnerSettingsController;
    @Inject
    private DatasourceSharingSettingsController datasourceSharingSettingsController;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private DHObjectMapper mapper;

    public Response setGlobalConfiguration(String message) {
        DatasourcesGlobalSettingsMsg newConfig;
        if (!this.dhUserService.isLoggedUserAdmin().booleanValue()) {
            return Response.status((int)403).build();
        }
        try {
            newConfig = this.mapper.readValue(message, DatasourcesGlobalSettingsMsg.class);
        }
        catch (Exception e) {
            log.error("Problems with the message format", (Throwable)e);
            return Response.status((int)400).build();
        }
        try {
            GenericRestrictionSettingsModel creationRestriction = new GenericRestrictionSettingsModel();
            if (newConfig.getDatasourceCreationRestriction().getRestricted().booleanValue()) {
                creationRestriction.setRestricted(true);
                creationRestriction.setAllowedUsersGroups(newConfig.getDatasourceCreationRestriction().getUserList());
            } else {
                creationRestriction.setRestricted(false);
            }
            GenericRestrictionSettingsModel ownerViewModeRestriction = new GenericRestrictionSettingsModel();
            if (newConfig.getDatasourceOwnerViewModeRestriction().getRestricted().booleanValue()) {
                ownerViewModeRestriction.setRestricted(true);
            } else {
                ownerViewModeRestriction.setRestricted(false);
            }
            GenericRestrictionSettingsModel shareRestriction = new GenericRestrictionSettingsModel();
            if (newConfig.getDatasourceShareRestriction().getRestricted().booleanValue()) {
                shareRestriction.setRestricted(true);
            } else {
                shareRestriction.setRestricted(false);
            }
            this.datasourceSettingsController.updateSettings(creationRestriction);
            this.datasourceRunAsOwnerSettingsController.updateSettings(ownerViewModeRestriction);
            this.datasourceSharingSettingsController.updateSettings(shareRestriction);
            HashMap<String, Boolean> responseData = new HashMap<String, Boolean>();
            responseData.put("ok", true);
            return ResponseBuilder.ok(responseData).build();
        }
        catch (Exception e) {
            log.error("Problems updating the access configuration", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

