/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.utils.images;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;

public class ImageUtil {
    private static final Set<String> SUPPORTED_MIME_TYPES = new HashSet<String>();

    private ImageUtil() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static String getImageMimeType(byte[] buffer) throws IOException {
        if (buffer == null || buffer.length == 0) {
            return null;
        }
        String mimeType = ImageUtil.detectByMagicBytes(buffer);
        if (mimeType == null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
            mimeType = URLConnection.guessContentTypeFromStream(inputStream);
        }
        return SUPPORTED_MIME_TYPES.contains(mimeType) ? mimeType : null;
    }

    static String detectByMagicBytes(byte[] buffer) {
        if (buffer == null || buffer.length < 4) {
            return null;
        }
        if (ImageUtil.matchesSignature(buffer, new int[]{137, 80, 78, 71})) {
            return "image/png";
        }
        if (ImageUtil.matchesSignature(buffer, new int[]{255, 216, 255})) {
            return "image/jpeg";
        }
        if (ImageUtil.matchesSignature(buffer, new int[]{71, 73, 70, 56})) {
            return "image/gif";
        }
        if (ImageUtil.matchesSignature(buffer, new int[]{66, 77})) {
            return "image/bmp";
        }
        if (buffer.length >= 12 && ImageUtil.matchesSignature(buffer, new int[]{82, 73, 70, 70}) && buffer[8] == 87 && buffer[9] == 69 && buffer[10] == 66 && buffer[11] == 80) {
            return "image/webp";
        }
        if (ImageUtil.matchesSignature(buffer, new int[]{73, 73, 42, 0}) || ImageUtil.matchesSignature(buffer, new int[]{77, 77, 0, 42})) {
            return "image/tiff";
        }
        if (ImageUtil.matchesSignature(buffer, new int[]{0, 0, 1, 0})) {
            return "image/x-icon";
        }
        if (ImageUtil.matchesSignature(buffer, new int[]{0, 0, 2, 0})) {
            return "image/x-icon";
        }
        if (ImageUtil.isHeicOrHeif(buffer)) {
            return "image/heic";
        }
        if (ImageUtil.isAvif(buffer)) {
            return "image/avif";
        }
        if (ImageUtil.isSvg(buffer)) {
            return "image/svg+xml";
        }
        if (buffer.length >= 8 && ImageUtil.matchesSignature(buffer, new int[]{0, 0, 0, 12, 106, 80, 32, 32})) {
            return "image/jp2";
        }
        return null;
    }

    private static boolean matchesSignature(byte[] buffer, int[] signature) {
        if (buffer.length < signature.length) {
            return false;
        }
        for (int i = 0; i < signature.length; ++i) {
            if ((buffer[i] & 0xFF) == signature[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isHeicOrHeif(byte[] buffer) {
        if (buffer.length < 12) {
            return false;
        }
        if (buffer[4] == 102 && buffer[5] == 116 && buffer[6] == 121 && buffer[7] == 112) {
            String brand = new String(buffer, 8, 4);
            return brand.equals("heic") || brand.equals("heix") || brand.equals("hevc") || brand.equals("hevx") || brand.equals("mif1") || brand.equals("msf1");
        }
        return false;
    }

    private static boolean isAvif(byte[] buffer) {
        if (buffer.length < 12) {
            return false;
        }
        if (buffer[4] == 102 && buffer[5] == 116 && buffer[6] == 121 && buffer[7] == 112) {
            String brand = new String(buffer, 8, 4);
            return brand.equals("avif") || brand.equals("avis");
        }
        return false;
    }

    private static boolean isSvg(byte[] buffer) {
        int checkLength = Math.min(buffer.length, 512);
        String header = new String(buffer, 0, checkLength);
        String headerLower = header.toLowerCase();
        return headerLower.contains("<svg") || headerLower.contains("<?xml") && headerLower.contains("<svg");
    }

    static {
        SUPPORTED_MIME_TYPES.add("image/svg+xml");
        SUPPORTED_MIME_TYPES.add("image/jpeg");
        SUPPORTED_MIME_TYPES.add("image/png");
        SUPPORTED_MIME_TYPES.add("image/gif");
        SUPPORTED_MIME_TYPES.add("image/webp");
        SUPPORTED_MIME_TYPES.add("image/tiff");
        SUPPORTED_MIME_TYPES.add("image/bmp");
        SUPPORTED_MIME_TYPES.add("image/x-ms-bmp");
        SUPPORTED_MIME_TYPES.add("image/x-icon");
        SUPPORTED_MIME_TYPES.add("image/vnd.microsoft.icon");
        SUPPORTED_MIME_TYPES.add("image/heic");
        SUPPORTED_MIME_TYPES.add("image/heif");
        SUPPORTED_MIME_TYPES.add("image/avif");
        SUPPORTED_MIME_TYPES.add("image/jp2");
        SUPPORTED_MIME_TYPES.add("image/x-portable-anymap");
        SUPPORTED_MIME_TYPES.add("image/x-portable-bitmap");
        SUPPORTED_MIME_TYPES.add("image/x-portable-graymap");
        SUPPORTED_MIME_TYPES.add("image/x-portable-pixmap");
    }
}

