/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.store.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.roninpixels.dashboardhub.ao.UserTemplate;
import com.roninpixels.dashboardhub.store.DHStoreObjectCallback;
import com.roninpixels.dashboardhub.store.UserTemplateRepository;
import com.roninpixels.dashboardhub.utils.crypto.Crypto;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.UserTemplateModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserTemplateRepositoryImpl
implements UserTemplateRepository {
    private static final Logger log = LoggerFactory.getLogger(UserTemplateRepositoryImpl.class);
    @ComponentImport
    private final ActiveObjects ao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final DHObjectMapper mapper;
    private final Crypto crypto;

    @Inject
    public UserTemplateRepositoryImpl(ActiveObjects ao, TransactionTemplate transactionTemplate, DHObjectMapper mapper, Crypto crypto) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.mapper = mapper;
        this.crypto = crypto;
    }

    @Override
    public List<UserTemplateModel> getUserTemplates(boolean includeDisabled) {
        return (List)this.transactionTemplate.execute(() -> {
            Query query = Query.select();
            if (!includeDisabled) {
                query = query.where("DISABLED != ?", new Object[]{true});
            }
            query = query.order("UPDATED DESC");
            UserTemplate[] templates = (UserTemplate[])this.ao.find(UserTemplate.class, query);
            ArrayList<UserTemplateModel> result = new ArrayList<UserTemplateModel>();
            for (UserTemplate template : templates) {
                result.add(this.toModel(template));
            }
            return result;
        });
    }

    @Override
    public UserTemplateModel getUserTemplate(String templateId) {
        return (UserTemplateModel)this.transactionTemplate.execute(() -> {
            UserTemplate template = this.findTemplateById(templateId);
            return template != null ? this.toModel(template) : null;
        });
    }

    @Override
    public UserTemplateModel createUserTemplate(UserTemplateModel template) {
        return (UserTemplateModel)this.transactionTemplate.execute(() -> {
            Date now = new Date();
            String encryptedDescriptor = null;
            try {
                if (template.getDescriptor() != null) {
                    encryptedDescriptor = this.crypto.encryptBackend(template.getDescriptor());
                }
            }
            catch (Exception e) {
                log.error("Failed to encrypt descriptor for template: {}", (Object)template.getTitle(), (Object)e);
                throw new RuntimeException("Failed to encrypt template descriptor", e);
            }
            UserTemplate newTemplate = (UserTemplate)this.ao.create(UserTemplate.class, new DBParam[]{new DBParam("TITLE", (Object)template.getTitle()), new DBParam("DESCRIPTION", (Object)template.getDescription()), new DBParam("ICON", (Object)template.getIcon()), new DBParam("TAGS", template.getTags() != null ? String.join((CharSequence)",", template.getTags()) : null), new DBParam("DESCRIPTOR", (Object)encryptedDescriptor), new DBParam("DISABLED", (Object)(template.getDisabled() != null ? template.getDisabled() : false)), new DBParam("OWNER", (Object)template.getOwner()), new DBParam("CREATED", (Object)now), new DBParam("UPDATED", (Object)now)});
            newTemplate.save();
            log.debug("UserTemplate created -> ID: {}, Title: {}", (Object)newTemplate.getID(), (Object)newTemplate.getTitle());
            return this.toModel(newTemplate);
        });
    }

    @Override
    public UserTemplateModel updateUserTemplate(String templateId, UserTemplateModel template) {
        return (UserTemplateModel)this.transactionTemplate.execute(() -> {
            UserTemplate existingTemplate = this.findTemplateById(templateId);
            if (existingTemplate == null) {
                return null;
            }
            String encryptedDescriptor = null;
            try {
                if (template.getDescriptor() != null) {
                    encryptedDescriptor = this.crypto.encryptBackend(template.getDescriptor());
                }
            }
            catch (Exception e) {
                log.error("Failed to encrypt descriptor for template update: {}", (Object)template.getTitle(), (Object)e);
                throw new RuntimeException("Failed to encrypt template descriptor", e);
            }
            existingTemplate.setTitle(template.getTitle());
            existingTemplate.setDescription(template.getDescription());
            existingTemplate.setIcon(template.getIcon());
            existingTemplate.setTags(template.getTags() != null ? String.join((CharSequence)",", template.getTags()) : null);
            existingTemplate.setDescriptor(encryptedDescriptor);
            existingTemplate.setDisabled(template.getDisabled() != null ? template.getDisabled() : false);
            existingTemplate.setOwner(template.getOwner());
            existingTemplate.setUpdated(new Date());
            existingTemplate.save();
            log.debug("UserTemplate updated -> ID: {}, Title: {}", (Object)existingTemplate.getID(), (Object)existingTemplate.getTitle());
            return this.toModel(existingTemplate);
        });
    }

    @Override
    public UserTemplateModel deleteUserTemplate(String templateId) {
        return (UserTemplateModel)this.transactionTemplate.execute(() -> {
            UserTemplate template = this.findTemplateById(templateId);
            if (template == null) {
                return null;
            }
            UserTemplateModel deletedTemplate = this.toModel(template);
            this.ao.delete(new RawEntity[]{template});
            log.debug("UserTemplate deleted -> ID: {}, Title: {}", (Object)template.getID(), (Object)template.getTitle());
            return deletedTemplate;
        });
    }

    private UserTemplate findTemplateById(String templateId) {
        Query query = Query.select();
        try {
            int dbId = Integer.parseInt(templateId);
            query = query.where("ID = ?", new Object[]{dbId});
        }
        catch (NumberFormatException e) {
            return null;
        }
        UserTemplate[] templates = (UserTemplate[])this.ao.find(UserTemplate.class, query);
        if (templates.length == 0) {
            return null;
        }
        if (templates.length > 1) {
            throw new RuntimeException(String.format("Multiple templates found with ID: %s", templateId));
        }
        return templates[0];
    }

    private UserTemplateModel toModel(UserTemplate template) {
        UserTemplateModel model = new UserTemplateModel();
        model.setId(String.valueOf(template.getID()));
        model.setTitle(template.getTitle());
        model.setDescription(template.getDescription());
        model.setIcon(template.getIcon());
        if (template.getTags() != null && !template.getTags().trim().isEmpty()) {
            model.setTags(Arrays.asList(template.getTags().split(",")));
        }
        String decryptedDescriptor = null;
        try {
            if (template.getDescriptor() != null) {
                decryptedDescriptor = this.crypto.decryptBackend(template.getDescriptor());
            }
        }
        catch (Exception e) {
            log.error("Failed to decrypt descriptor for template ID: {}", (Object)template.getID(), (Object)e);
            decryptedDescriptor = template.getDescriptor();
        }
        model.setDescriptor(decryptedDescriptor);
        model.setDisabled(template.getDisabled());
        model.setOwner(template.getOwner());
        model.setCreated(template.getCreated());
        model.setUpdated(template.getUpdated());
        return model;
    }

    public void stream(DHStoreObjectCallback callback) {
        this.ao.stream(UserTemplate.class, template -> callback.onObjectRead(this.toModel((UserTemplate)template)));
    }
}

