/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.servlet.dashboardfilters.filter;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.controllers.DashboardFilterRulesController;
import com.roninpixels.dashboardhub.confluence.dashboardfilters.web.models.DashboardFilterRule;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DHGlobalDashboardFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(DHGlobalDashboardFilter.class);
    public static final String GLOBAL_DASHBOARD_URL = "/plugins/dashboardHub/dashboards.action?ac.boardToken=";
    public static final String GLOBAL_DASHBOARD_NOT_FOUND_URL = "/plugins/servlet/dashboardHub/notFound";
    public static final String DASHBOARD_PAGE_URL = "/plugins/dashboardHub/filterRulesPageDashboard.action?pageId=";
    public static final String PAGES_VIEWPAGE_ACTION_PAGE_ID = "/pages/viewpage.action?pageId=";
    public static final String HOMEPAGE_ACTION = "/homepage.action";
    public static final String DISPLAY_PROFILE_URL = "/display/~";
    @Inject
    @ConfluenceImport
    private PageManager pageManager;
    @Inject
    @ConfluenceImport
    private PermissionManager permissionManager;
    @Inject
    @ConfluenceImport
    private SpaceManager spaceManager;
    @Inject
    @ConfluenceImport
    private UserAccessor userAccessor;
    @Inject
    private SettingsManager settingsManager;
    @Inject
    @ConfluenceImport
    private SpacePermissionManager spacePermissionManager;
    @Inject
    private DashboardFilterRulesController dashboardFilterRulesController;
    @Inject
    private BoardsController boardsController;
    @Inject
    private UserPreferencesAccessor userPreferencesAccessor;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (response.isCommitted() || currentUser == null) {
            chain.doFilter(request, response);
            return;
        }
        List<DashboardFilterRule> dashboardFilterRules = this.dashboardFilterRulesController.getDashboardFilterRules();
        if (dashboardFilterRules == null || dashboardFilterRules.isEmpty()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String contextPath = httpRequest.getContextPath();
        for (DashboardFilterRule dashboardFilterRule : dashboardFilterRules) {
            if (!this.isRuleAppliedToUser(request, response, chain, currentUser, dashboardFilterRule)) continue;
            switch (dashboardFilterRule.getDashboardLocation()) {
                case GLOBAL_DASHBOARD: {
                    this.filterToGlobalDashboard(httpResponse, contextPath, dashboardFilterRule);
                    return;
                }
                case SITE_HOMEPAGE: {
                    this.filterToSiteHomePage(request, response, chain, currentUser, httpResponse, contextPath, dashboardFilterRule);
                    return;
                }
                case WIKI_PAGE: {
                    this.filterToWikiPage(request, response, httpResponse, contextPath, dashboardFilterRule);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    private boolean isRuleAppliedToUser(ServletRequest request, ServletResponse response, FilterChain chain, ConfluenceUser currentUser, DashboardFilterRule dashboardFilterRule) throws IOException, ServletException {
        return dashboardFilterRule.isRestrictedToAllUsers() || this.userIsInRestrictedGroup((User)currentUser, dashboardFilterRule.getRestrictedGroups()) || currentUser != null && dashboardFilterRule.getRestrictedUsers().contains(currentUser.getKey().getStringValue());
    }

    private void filterToWikiPage(ServletRequest request, ServletResponse response, HttpServletResponse httpResponse, String contextPath, DashboardFilterRule dashboardFilterRule) throws ServletException, IOException {
        if (dashboardFilterRule.isRenderedAsDashboardAction()) {
            request.getRequestDispatcher(DASHBOARD_PAGE_URL + dashboardFilterRule.getWikiPageId()).forward(request, response);
        } else {
            httpResponse.sendRedirect(contextPath + PAGES_VIEWPAGE_ACTION_PAGE_ID + dashboardFilterRule.getWikiPageId());
        }
    }

    private void filterToSiteHomePage(ServletRequest request, ServletResponse response, FilterChain chain, ConfluenceUser currentUser, HttpServletResponse httpResponse, String contextPath, DashboardFilterRule dashboardFilterRule) throws IOException, ServletException {
        String userHomePage = this.userPreferencesAccessor.getConfluenceUserPreferences((User)currentUser).getWrappedPreferences().getString("confluence.user.site.homepage");
        String siteHomePage = this.settingsManager.getGlobalSettings().getSiteHomePage();
        if ("dashboard".equals(userHomePage) || ("siteHomepage".equals(userHomePage) || userHomePage == null) && siteHomePage == null) {
            chain.doFilter(request, response);
        } else {
            if (!dashboardFilterRule.isRenderedAsDashboardAction()) {
                httpResponse.sendRedirect(contextPath + HOMEPAGE_ACTION);
                return;
            }
            if (this.filterToSiteHomePageAsDashboard(request, response, chain, currentUser, httpResponse, contextPath, userHomePage, siteHomePage)) {
                return;
            }
            chain.doFilter(request, response);
        }
    }

    private boolean filterToSiteHomePageAsDashboard(ServletRequest request, ServletResponse response, FilterChain chain, ConfluenceUser currentUser, HttpServletResponse httpResponse, String contextPath, String userHomePage, String siteHomePage) throws IOException, ServletException {
        Space personalSpace;
        ArrayList<String> permissionTypes = new ArrayList<String>();
        permissionTypes.add("USECONFLUENCE");
        permissionTypes.add("VIEWSPACE");
        if (StringUtils.isBlank((String)userHomePage) || "siteHomepage".equals(userHomePage)) {
            if (StringUtils.isBlank((String)siteHomePage)) {
                chain.doFilter(request, response);
                return true;
            }
            Space space = this.spaceManager.getSpace(siteHomePage);
            if (space != null && this.spacePermissionManager.hasAllPermissions(permissionTypes, space, (User)currentUser) && space.getHomePage() != null) {
                request.getRequestDispatcher(DASHBOARD_PAGE_URL + space.getHomePage().getIdAsString()).forward(request, response);
                return true;
            }
            chain.doFilter(request, response);
            return true;
        }
        if ("profile".equals(userHomePage)) {
            httpResponse.sendRedirect(contextPath + DISPLAY_PROFILE_URL + currentUser.getName());
            return true;
        }
        if (userHomePage.equals("~" + currentUser.getName()) && (personalSpace = this.spaceManager.getPersonalSpace(currentUser)) != null && personalSpace.getHomePage() != null) {
            request.getRequestDispatcher(DASHBOARD_PAGE_URL + personalSpace.getHomePage().getIdAsString()).forward(request, response);
            return true;
        }
        Space space = this.spaceManager.getSpace(userHomePage);
        if (space != null && this.spacePermissionManager.hasAllPermissions(permissionTypes, space, (User)currentUser) && space.getHomePage() != null) {
            request.getRequestDispatcher(DASHBOARD_PAGE_URL + space.getHomePage().getIdAsString()).forward(request, response);
            return true;
        }
        return false;
    }

    private void filterToGlobalDashboard(HttpServletResponse httpResponse, String contextPath, DashboardFilterRule dashboardFilterRule) throws IOException {
        String boardToken = this.getSerializedBoard(dashboardFilterRule.getGlobalDashboardId());
        if (boardToken != null) {
            httpResponse.sendRedirect(contextPath + GLOBAL_DASHBOARD_URL + URLEncoder.encode(boardToken, StandardCharsets.UTF_8.toString()));
        } else {
            httpResponse.sendRedirect(contextPath + GLOBAL_DASHBOARD_NOT_FOUND_URL);
        }
    }

    public void destroy() {
    }

    private boolean userIsInRestrictedGroup(User user, List<String> restrictedGroups) {
        if (user != null) {
            List userGroups = this.userAccessor.getGroupNames(user);
            for (String userGroup : userGroups) {
                if (!restrictedGroups.contains(userGroup)) continue;
                return true;
            }
        }
        return false;
    }

    private String getSerializedBoard(String boardId) throws IOException {
        BoardModel board = this.boardsController.getBoard(boardId);
        if (board == null) {
            LOG.error("Board not found");
            return null;
        }
        return board.getToken();
    }
}

