/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.gadgetsRequesters.CDM;

import com.roninpixels.dashboardhub.gadgetsRequesters.confluence.CQLSearch;
import com.roninpixels.dashboardhub.gadgetsRequesters.jira.software.utils.JqlUtils;
import com.roninpixels.dashboardhub.gadgetsRequesters.model.customChartsConfig.CQLSearchConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDMSearch
extends CQLSearch {
    private static final Logger log = LoggerFactory.getLogger(CDMSearch.class);
    private static final List<String> CDM_DEFAULT_FIELDS = Arrays.asList("parameters");
    public static final String CQL_ALLOWED_CONTENT_TYPES = "type in (page, blogpost)";
    public static final String EXPAND_PREFIX = "metadata.properties.";
    private static final Map<String, String> CDM_EXPANDERS = new HashMap<String, String>();

    @Override
    protected List<String> getDefaultFields() {
        List<String> defaultFields = super.getDefaultFields();
        defaultFields.addAll(CDM_DEFAULT_FIELDS);
        return defaultFields;
    }

    @Override
    protected String getExpandValue(String fieldKey) {
        String value = super.getExpandValue(fieldKey);
        if (value == null && CDM_EXPANDERS.containsKey(fieldKey)) {
            value = String.format("%s%s", EXPAND_PREFIX, CDM_EXPANDERS.get(fieldKey));
        }
        return value;
    }

    @Override
    protected String getCQL(CQLSearchConfig config) {
        String cCQL = config.getCql();
        if (cCQL == null || cCQL.trim().isEmpty()) {
            return CQL_ALLOWED_CONTENT_TYPES;
        }
        return JqlUtils.appendExtranCondition(cCQL, CQL_ALLOWED_CONTENT_TYPES);
    }

    static {
        CDM_EXPANDERS.put("workflowName", "comalaworkflows.workflowName");
        CDM_EXPANDERS.put("currentState", "comalaworkflows.currentState,metadata.properties.comalaworkflows.currentStateColour");
        CDM_EXPANDERS.put("currentStateStart", "comalaworkflows.currentStateStart");
        CDM_EXPANDERS.put("currentStateStartedBy", "comalaworkflows.currentStateStartedBy");
        CDM_EXPANDERS.put("isFinal", "comalaworkflows.isFinal");
        CDM_EXPANDERS.put("dueDate", "comalaworkflows.dueDate");
        CDM_EXPANDERS.put("lastFinalVersionId", "comalaworkflows.lastFinalVersionId");
        CDM_EXPANDERS.put("lastFinalVersionNumber", "comalaworkflows.lastFinalVersionNumber");
        CDM_EXPANDERS.put("lastFinalVersionDate", "comalaworkflows.lastFinalVersionDate");
        CDM_EXPANDERS.put("hasWorkflow", "comalaworkflows.hasWorkflow");
        CDM_EXPANDERS.put("approvers-pending", "comalaworkflowspendingapprovers.userKeyList");
        CDM_EXPANDERS.put("approvers-finished", "comalaworkflowsfinishedapprovers.userKeyList");
        CDM_EXPANDERS.put("approvers-lastfinalversion", "comalaworkflowslastfinalversionapprovers.userKeyList");
        CDM_EXPANDERS.put("approvals-pending", "comalaworkflowspendingapprovals.approvalNameList");
        CDM_EXPANDERS.put("approvals-approved", "comalaworkflowsapprovedapprovals.approvalNameList");
        CDM_EXPANDERS.put("approvals-rejected", "comalaworkflowsrejectedapprovals.approvalNameList");
        CDM_EXPANDERS.put("currentmodelversion", "comalaworflowscurrentmodelversion.version");
        CDM_EXPANDERS.put("parameters", "comalaworkflowparameters.workflowparameters");
    }
}

