/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.volatil;

import com.roninpixels.dashboardhub.controllers.volatil.UnlockBoardTokenController;
import com.roninpixels.dashboardhub.store.volatil.UnlockBoardAttemptsRepository;
import com.roninpixels.dashboardhub.web.models.volatil.UnlockBoardAttemptModel;
import java.util.Date;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class UnlockBoardTokenControllerImpl
implements UnlockBoardTokenController {
    @Inject
    private UnlockBoardAttemptsRepository repo;
    private final long trialsTime;
    private final long expirationTime;

    public UnlockBoardTokenControllerImpl(Long expirationTime, Long trialsTime) {
        this.expirationTime = expirationTime == null ? 3600000L : expirationTime;
        this.trialsTime = trialsTime == null ? 600000L : trialsTime;
    }

    public UnlockBoardTokenControllerImpl() {
        this(null, null);
    }

    boolean isExpired(UnlockBoardAttemptModel attempt) {
        return attempt != null && attempt.getExpirationTime() != null && attempt.getExpirationTime().getTime() < System.currentTimeMillis();
    }

    @Override
    public UnlockBoardAttemptModel incrementTrial(String key, String boardId) {
        UnlockBoardAttemptModel attempt = this.repo.get(key, boardId);
        if (attempt == null || this.isExpired(attempt)) {
            attempt = new UnlockBoardAttemptModel(key, boardId);
            attempt.setTrialNumber(1);
            attempt.setExpirationTime(new Date(System.currentTimeMillis() + 600000L));
        } else {
            attempt.setTrialNumber(attempt.getTrialNumber() + 1);
            if (attempt.getTrialNumber() >= MAX_TRIALS) {
                Date expirationDate = new Date(System.currentTimeMillis() + 3600000L);
                attempt.setExpirationTime(expirationDate);
            }
        }
        this.repo.save(attempt);
        return attempt;
    }

    @Override
    public void removeAttempt(String key, String boardToken) {
        this.repo.remove(key, boardToken);
    }

    @Override
    public boolean checkExpirationExceeded(String key, String boardId) {
        UnlockBoardAttemptModel model = this.repo.get(key, boardId);
        return model != null && this.isExpired(model);
    }

    @Override
    public UnlockBoardAttemptModel getLockedAttempt(UnlockBoardAttemptModel model) {
        if (model == null || this.isExpired(model) || model.getTrialNumber() < MAX_TRIALS) {
            return null;
        }
        return model;
    }

    @Override
    public UnlockBoardAttemptModel getLockedAttempt(String key, String boardId) {
        UnlockBoardAttemptModel model = this.repo.get(key, boardId);
        return this.getLockedAttempt(model);
    }
}

