/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.impl;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.roninpixels.dashboardhub.config.frontedModel.FeatureManagementSettingsModel;
import com.roninpixels.dashboardhub.controllers.FeatureManagementController;
import com.roninpixels.dashboardhub.exceptions.NotAuthorizedException;
import com.roninpixels.dashboardhub.services.DHUserService;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class FeatureManagementControllerImpl
implements FeatureManagementController {
    static final String PROP_NAME_FEATURE_MANAGEMENT_SETTINGS_LEGACY_FEATURES = "com.roninpixels.dashboardhub:featureManagement.settings.legacyFeatures";
    static final String PROP_NAME_FEATURE_MANAGEMENT_SETTINGS_ANALYTICS = "com.roninpixels.dashboardhub:featureManagement.settings.analytics";
    @Inject
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    @Inject
    private DHUserService userService;

    @Override
    public void updateFeatureManagementSettings(FeatureManagementSettingsModel newSettings) {
        if (!this.userService.isLoggedUserAdmin().booleanValue()) {
            throw new NotAuthorizedException();
        }
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put(PROP_NAME_FEATURE_MANAGEMENT_SETTINGS_LEGACY_FEATURES, newSettings.getLegacyFeatures());
        pluginSettings.put(PROP_NAME_FEATURE_MANAGEMENT_SETTINGS_ANALYTICS, (Object)String.valueOf(newSettings.isAnalytics()));
    }

    @Override
    public FeatureManagementSettingsModel getFeatureManagementSettings() {
        FeatureManagementSettingsModel settings = new FeatureManagementSettingsModel();
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object legacyFeatures = pluginSettings.get(PROP_NAME_FEATURE_MANAGEMENT_SETTINGS_LEGACY_FEATURES);
        if (legacyFeatures != null) {
            settings.setLegacyFeatures((List)legacyFeatures);
        } else {
            settings.setLegacyFeatures(Collections.emptyList());
        }
        settings.setAnalytics(this.isAnalytics(pluginSettings));
        return settings;
    }

    private boolean isAnalytics(PluginSettings pluginSettings) {
        Object enableAnalytics = pluginSettings.get(PROP_NAME_FEATURE_MANAGEMENT_SETTINGS_ANALYTICS);
        return Boolean.valueOf((String)enableAnalytics);
    }

    @Override
    public boolean isAnalytics() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        return this.isAnalytics(pluginSettings);
    }
}

