/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.gadgets;

import com.roninpixels.dashboardhub.controllers.BoardPermissionsController;
import com.roninpixels.dashboardhub.controllers.DatasourceSharingSettingsController;
import com.roninpixels.dashboardhub.controllers.gadgets.GadgetsValidationController;
import com.roninpixels.dashboardhub.gadgetsValidators.GadgetValidator;
import com.roninpixels.dashboardhub.gadgetsValidators.ValidationResponse;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class GadgetsValidationControllerImpl
implements GadgetsValidationController {
    @Inject
    private ApplicationContext context;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private BoardPermissionsController boardPermissionsController;
    @Inject
    private DatasourcesController datasourcesController;
    @Inject
    private DatasourceSharingSettingsController datasourceSharingSettingsController;

    @Override
    public ValidationResponse validateDataFor(BoardModel board, BoardModel originalBoard) {
        ValidationResponse response = new ValidationResponse(true);
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.validateBoard(board, originalBoard));
        if (errors.isEmpty()) {
            board.getData().stream().forEach(slide -> slide.stream().forEach(gadget -> {
                ValidationResponse validation = this.validateGadget((GadgetModel)gadget);
                errors.addAll(validation.getErrors());
            }));
        }
        if (!errors.isEmpty()) {
            response.setValid(false);
            response.getErrors().addAll(errors);
        }
        return response;
    }

    @Override
    public ValidationResponse validateDataForCloned(BoardModel originalBoard) {
        ValidationResponse response = new ValidationResponse(true);
        String userKey = this.dhUserService.getLoggedInUserKey();
        boolean isBoardVisible = this.boardPermissionsController.isBoardVisibleFor(originalBoard, userKey);
        if (!isBoardVisible) {
            ArrayList<String> errors = new ArrayList<String>();
            errors.add("Board permission denied");
            response.setErrors(errors);
            response.setValid(false);
        }
        return response;
    }

    @Override
    public ValidationResponse validateDataFor(GadgetModel gadget) {
        return this.validateGadget(gadget);
    }

    private GadgetValidator getGadgetValidator(GadgetModel gadget) {
        String widget = gadget.getWidget() + "Validator";
        if (!this.context.containsBean(widget)) {
            return null;
        }
        return (GadgetValidator)this.context.getBean(widget, GadgetValidator.class);
    }

    private ValidationResponse validateGadget(GadgetModel gadget) {
        GadgetValidator validator = this.getGadgetValidator(gadget);
        if (validator != null) {
            return validator.validateData(gadget);
        }
        return new ValidationResponse(true);
    }

    private List<String> validateBoard(BoardModel board, BoardModel originalBoard) {
        try {
            return this.validateGadgetsDatasourcePermissions(board, originalBoard);
        }
        catch (Exception e) {
            ArrayList<String> errors = new ArrayList<String>(Arrays.asList("Error on validateBoard " + e.getMessage()));
            return errors;
        }
    }

    private List<String> validateGadgetsDatasourcePermissions(BoardModel board, BoardModel originalBoard) throws IOException {
        List<String> errors;
        String userKey = this.dhUserService.getLoggedInUserKey();
        List<DatasourceModel> datasourcesWithPermissions = this.datasourcesController.getDatasources(userKey);
        ArrayList originalData = originalBoard == null ? new ArrayList() : originalBoard.getData().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List data = board.getData().stream().flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<String, String> originalDataObject = new HashMap<String, String>();
        HashMap<String, String> modifiedDataObject = new HashMap<String, String>();
        for (GadgetModel item : originalData) {
            if (item.getConfig() == null || item.getConfig().getDatasource() == null || item.getConfig().getDatasource().getId() == null) continue;
            originalDataObject.put(item.getId(), item.getConfig().getDatasource().getId());
        }
        for (GadgetModel item : data) {
            if (item.getConfig() == null || item.getConfig().getDatasource() == null || item.getConfig().getDatasource().getId() == null) continue;
            modifiedDataObject.put(item.getId(), item.getConfig().getDatasource().getId());
        }
        String loggedUserKey = this.dhUserService.getLoggedInUserKey();
        for (String id : originalDataObject.keySet()) {
            if (modifiedDataObject.containsKey(id) && !((String)originalDataObject.get(id)).equals(modifiedDataObject.get(id)) && (errors = this.checkPermissionsWithDSList(datasourcesWithPermissions, (String)modifiedDataObject.get(id), loggedUserKey)) != null) {
                return errors;
            }
            modifiedDataObject.remove(id);
        }
        for (String idNew : modifiedDataObject.keySet()) {
            errors = this.checkPermissionsWithDSList(datasourcesWithPermissions, (String)modifiedDataObject.get(idNew), loggedUserKey);
            if (errors == null) continue;
            return errors;
        }
        return Collections.emptyList();
    }

    private List<String> checkPermissionsWithDSList(List<DatasourceModel> datasourcesWithPermissions, String id, String loggedUserKey) {
        boolean hasPermission = datasourcesWithPermissions.stream().anyMatch(datasource -> {
            if (this.datasourceSharingSettingsController.isSharingRestricted()) {
                return datasource.getId().equals(id) && datasource.getCreator().equals(loggedUserKey);
            }
            return datasource.getId().equals(id);
        });
        if (!hasPermission) {
            return new ArrayList<String>(Arrays.asList("The user does not have permission to use this datasource"));
        }
        return null;
    }
}

