/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers.bigpicture;

import com.roninpixels.dashboardhub.connectors.interfaces.BigPictureConnector;
import com.roninpixels.dashboardhub.controllers.bigpicture.BigPictureController;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.AvailableDataTypesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.Box;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxFieldDefinitionsResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxFlattened;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxHierarchyResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxSelectedFieldsResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxStatusesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.BoxTypesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.DataType;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskBoxFieldValues;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskFieldsResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TaskFieldsValuesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.models.TasksInBoxesResponse;
import com.roninpixels.dashboardhub.controllers.bigpicture.utils.MappingUtils;
import com.roninpixels.dashboardhub.exceptions.BadRequestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigPictureControllerImpl
implements BigPictureController {
    private static final Logger log = LoggerFactory.getLogger(BigPictureControllerImpl.class);
    public static final int MAX_BOX_SUPPORTED_FIELD_ID = 99;
    public static final int MIN_BOX_SUPPORTED_CUSTOM_FIELD_ID = 10000;
    private BigPictureConnector bigPictureConnector;

    public BigPictureControllerImpl(BigPictureConnector bigPictureConnector) {
        this.bigPictureConnector = bigPictureConnector;
    }

    @Override
    public List<Map> getBoxFields() {
        BoxFieldDefinitionsResponse boxFieldDefinitionsResponse = this.bigPictureConnector.getBoxFieldDefinitions();
        AvailableDataTypesResponse dataTypesResponse = this.bigPictureConnector.getAvailableDataTypes();
        if (boxFieldDefinitionsResponse.getCargo() == null || boxFieldDefinitionsResponse.getCargo().getBoxFieldDefinitions() == null || dataTypesResponse.getCargo() == null || dataTypesResponse.getCargo().getDataTypes() == null) {
            log.error("No box field definitions or available data types found");
            throw new BadRequestException(400, "No box field definitions or available data types found");
        }
        Map<String, DataType> dataTypeById = MappingUtils.keyByDataTypes(dataTypesResponse.getCargo().getDataTypes());
        return boxFieldDefinitionsResponse.getCargo().getBoxFieldDefinitions().stream().filter(rawFieldDefinition -> rawFieldDefinition.getBoxFieldDefinitionId() <= 99 || rawFieldDefinition.getBoxFieldDefinitionId() >= 10000).map(rawField -> MappingUtils.mapBoxFieldDefinition(dataTypeById, rawField)).collect(Collectors.toList());
    }

    @Override
    public List<Map> getBoxTypes() {
        BoxTypesResponse boxTypesResponse = this.bigPictureConnector.getBoxTypes();
        if (boxTypesResponse.getCargo() == null || boxTypesResponse.getCargo().isEmpty()) {
            throw new BadRequestException(400, "No box types found");
        }
        return boxTypesResponse.getCargo().stream().map(boxType -> MappingUtils.mapBoxType(boxType)).collect(Collectors.toList());
    }

    @Override
    public List<Map> getBoxStatuses() {
        BoxStatusesResponse boxStatusesResponse = this.bigPictureConnector.getAvailableStatus();
        if (boxStatusesResponse.getCargo() == null || boxStatusesResponse.getCargo().isEmpty()) {
            throw new BadRequestException(400, "No box statuses found");
        }
        return boxStatusesResponse.getCargo().stream().map(boxStatus -> MappingUtils.mapBoxStatus(boxStatus)).collect(Collectors.toList());
    }

    @Override
    public Box getBoxesTree() {
        BoxHierarchyResponse boxHierarchyResponse = this.bigPictureConnector.getBoxHierarchy();
        if (boxHierarchyResponse.getCargo() == null) {
            throw new BadRequestException(400, "No box hierarchy found");
        }
        List<Map> boxStatuses = this.getBoxStatuses();
        Box boxesTree = MappingUtils.mapBoxesTree(boxHierarchyResponse.getCargo(), boxStatuses);
        return boxesTree;
    }

    @Override
    public List<BoxFlattened> getBoxesFlattened() {
        BoxHierarchyResponse boxHierarchyResponse = this.bigPictureConnector.getBoxHierarchy();
        if (boxHierarchyResponse.getCargo() == null) {
            throw new BadRequestException(400, "No box hierarchy found");
        }
        List<BoxFlattened> flattenedBoxes = MappingUtils.flatBoxChildren(boxHierarchyResponse.getCargo());
        return flattenedBoxes;
    }

    @Override
    public Map<String, Map<String, Map>> getBoxFieldValues(List<String> boxIds, List<String> fieldIds) throws Exception {
        if (boxIds == null || boxIds.isEmpty() || fieldIds == null || fieldIds.isEmpty()) {
            throw new IllegalArgumentException("Box ids and field ids must be provided");
        }
        List<String> filteredFieldIds = MappingUtils.removeEntityFieldsFromList(fieldIds);
        Map<String, List<String>> fields = MappingUtils.mapFieldIdsWithAggregation(filteredFieldIds);
        BoxSelectedFieldsResponse boxFieldValues = this.bigPictureConnector.getBoxSelectedFields(boxIds, fields);
        Map<String, Map<String, Map>> boxFieldValuesMap = MappingUtils.mapBoxFieldValuesFromAPI(boxFieldValues.getCargo().getFields(), filteredFieldIds);
        return boxFieldValuesMap;
    }

    @Override
    public List<Map> getColors() {
        List colors = this.bigPictureConnector.getColors();
        if (colors == null || colors.isEmpty()) {
            log.error("No colors found");
            return new ArrayList<Map>();
        }
        return colors;
    }

    @Override
    public List<Map> getTaskFields() {
        TaskFieldsResponse taskFieldDefinitionsResponse = this.bigPictureConnector.getTaskFieldDefinitions();
        if (taskFieldDefinitionsResponse == null || taskFieldDefinitionsResponse.getCargo() == null || taskFieldDefinitionsResponse.getCargo().getGlobalFieldDefinitions() == null) {
            throw new BadRequestException(400, "No task field definitions found");
        }
        return taskFieldDefinitionsResponse.getCargo().getGlobalFieldDefinitions().stream().map(taskField -> MappingUtils.mapTaskFieldDefinition(taskField)).collect(Collectors.toList());
    }

    private List<Map> getSelectedFields(List<String> fieldIds) {
        List<Map> taskFields = this.getTaskFields();
        List<Map> selectedFields = MappingUtils.extractTaskFieldsFromIds(fieldIds, taskFields);
        if (selectedFields.isEmpty()) {
            throw new BadRequestException(400, "No selected fields found");
        }
        return selectedFields;
    }

    @Override
    public List<TaskBoxFieldValues> getTaskFieldsValues(List<String> boxIds, List<String> fieldIds) throws Exception {
        if (boxIds == null || boxIds.isEmpty() || fieldIds == null || fieldIds.isEmpty()) {
            throw new IllegalArgumentException("Box ids and field ids must be provided");
        }
        List<Map> selectedFields = this.getSelectedFields(fieldIds);
        TasksInBoxesResponse tasksInBoxes = this.bigPictureConnector.getTaskInBoxes(boxIds);
        Map<String, List<String>> taskIdsByBoxId = MappingUtils.taskIdsByBoxIdFromAPI(tasksInBoxes);
        List<String> taskIds = taskIdsByBoxId.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (taskIds.isEmpty()) {
            return new ArrayList<TaskBoxFieldValues>();
        }
        List<String> fieldNames = selectedFields.stream().map(field -> (String)field.get("label")).collect(Collectors.toList());
        TaskFieldsValuesResponse taskFieldValues = this.bigPictureConnector.getTaskFieldValues(taskIds, fieldNames);
        return MappingUtils.mapTaskFieldValuesFromAPI(taskFieldValues.getCargo().getTasksFields(), selectedFields, taskIdsByBoxId);
    }

    private Map getMainExtPlatform() {
        List<Map> extPlatforms = this.bigPictureConnector.getExtPlatforms();
        return extPlatforms.stream().filter(extPlatform -> extPlatform.get("isPrimary") != null && (Boolean)extPlatform.get("isPrimary") != false && extPlatform.get("isActive") != null && (Boolean)extPlatform.get("isActive") != false).findFirst().orElse(extPlatforms.stream().filter(extPlatform -> extPlatform.get("isPrimary") != null && (Boolean)extPlatform.get("isPrimary") != false).findFirst().orElse(null));
    }

    @Override
    public Map getWorkingScheme() {
        Map mainExtPlatform = this.getMainExtPlatform();
        if (mainExtPlatform == null) {
            throw new BadRequestException(400, "No working scheme found");
        }
        return this.bigPictureConnector.getWorkingScheme(mainExtPlatform.get("id").toString());
    }
}

