/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.controllers;

import com.roninpixels.dashboardhub.controllers.DatasourcePermissionsController;
import com.roninpixels.dashboardhub.controllers.DatasourceSharingSettingsController;
import com.roninpixels.dashboardhub.datasources.DatasourceGenerator;
import com.roninpixels.dashboardhub.datasources.DatasourcesUtil;
import com.roninpixels.dashboardhub.exceptions.BadDatasourceException;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import com.roninpixels.dashboardhub.permissions.AccessManager;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.store.DHDatasourcesRepository;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import com.roninpixels.dashboardhub.web.models.GadgetConfigModel;
import com.roninpixels.dashboardhub.web.models.GadgetModel;
import com.roninpixels.dashboardhub.web.models.RestrictionModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DatasourcesControllerV2
implements DatasourcesController {
    private static final Logger log = LoggerFactory.getLogger(DatasourcesControllerV2.class);
    @Inject
    private DHUserService dhUserService;
    @Inject
    private DHDatasourcesRepository dsRepo;
    @Inject
    private DatasourceGenerator dsGenerator;
    @Inject
    private DatasourcesUtil dsUtils;
    @Inject
    private DatasourcePermissionsController dsPermissionsController;
    @Inject
    private AccessManager dsAccessManager;
    @Inject
    private DatasourceSharingSettingsController datasourceSharingSettingsController;

    private void validateCanMakeChangesBasedOnRestrictions(DatasourceModel ds) {
        boolean isSharingRestricted = this.datasourceSharingSettingsController.isSharingRestricted();
        if (!DatasourcesUtil.canSaveOrUpdateDatasource(ds, isSharingRestricted)) {
            throw new DhUserException(400, null, "Datasource sharing is restricted");
        }
    }

    @Override
    public List<DatasourceModel> getDatasources(String userKey) throws IOException {
        if (userKey == null) {
            return Collections.emptyList();
        }
        List<DatasourceModel> ownerDatasources = this.getOwnerDatasources(userKey);
        if (this.datasourceSharingSettingsController.isSharingRestricted()) {
            return ownerDatasources.stream().map(ds -> {
                ds.setRestrictions(DatasourcesUtil.createDefaultDatasourceRestrictions());
                return ds;
            }).collect(Collectors.toList());
        }
        List ownerDatasourcesIds = ownerDatasources.stream().map(DatasourceModel::getId).collect(Collectors.toList());
        List<DatasourceModel> sharedWithMeDatasources = this.getSharedWithMeDatasources(userKey).stream().filter(ds -> !ownerDatasourcesIds.contains(ds.getId())).collect(Collectors.toList());
        List sharedWithMeDatasourcesIds = sharedWithMeDatasources.stream().map(DatasourceModel::getId).collect(Collectors.toList());
        List globalDatasources = this.getGlobalDatasources(userKey).stream().filter(ds -> !sharedWithMeDatasourcesIds.contains(ds.getId()) && !ownerDatasourcesIds.contains(ds.getId())).collect(Collectors.toList());
        this.setEditPermissionsIfNeeded(sharedWithMeDatasources);
        List<DatasourceModel> allDatasources = Stream.concat(Stream.concat(ownerDatasources.stream(), globalDatasources.stream()), sharedWithMeDatasources.stream()).collect(Collectors.toList());
        allDatasources.stream().filter(ds -> "customreports".equals(ds.getProduct())).forEach(this::addHeadersParamsInfo);
        return allDatasources;
    }

    private void setEditPermissionsIfNeeded(List<DatasourceModel> datasources) {
        datasources.stream().forEach(ds -> {
            if (this.dsAccessManager.canUserLoggedInEdit((RestrictionModel)ds)) {
                ds.setPermission("canEdit");
            }
        });
    }

    private List<DatasourceModel> getSharedWithMeDatasources(String userKey) {
        List<DatasourceModel> sharedWithMeDatasources = this.dsPermissionsController.getAccesibleDatasourceIds(userKey).stream().map(dsId -> {
            try {
                DatasourceModel ds = this.getDatasource((String)dsId);
                ds.setPermission("canUse");
                return ds;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return sharedWithMeDatasources;
    }

    private List<DatasourceModel> getOwnerDatasources(String ownerKey) {
        List<DatasourceModel> ownerDatasources = this.dsRepo.getDatasourcesByOwner(ownerKey);
        ownerDatasources.stream().forEach(ds -> ds.setPermission("canEdit"));
        return ownerDatasources;
    }

    private List<DatasourceModel> getGlobalDatasources(String ownerKey) {
        List<DatasourceModel> globalDatasources = this.dsRepo.getGlobalDatasources();
        return globalDatasources.stream().filter(ds -> ds.getCreator() != ownerKey).map(ds -> {
            if (ds.getRestrictions() != null && ds.getRestrictions().getType().equals("anyUseEdit")) {
                ds.setPermission("canEdit");
            } else {
                ds.setPermission("canUse");
            }
            return ds;
        }).collect(Collectors.toList());
    }

    @Override
    public List<DatasourceModel> getDatasources() throws IOException {
        AppUser user = this.dhUserService.getLoggedInUser();
        return this.getDatasources(user == null ? null : user.getKey());
    }

    @Override
    public DatasourceModel getDatasource(String id) throws IOException {
        DatasourceModel ds = this.dsRepo.getDatasource(id);
        DatasourcesUtil.setNewRestrictions(ds);
        return ds;
    }

    @Override
    public DatasourceModel getDatasourceWithExtraInfo(String id) throws IOException {
        DatasourceModel targetDs = this.dsRepo.getDatasourceWithExtraInfo(id);
        if (this.datasourceSharingSettingsController.isSharingRestricted()) {
            targetDs.setRestrictions(DatasourcesUtil.createDefaultDatasourceRestrictions());
            DatasourcesUtil.setRestrictionTypeBasedOnRestrictions(targetDs);
        }
        DatasourcesUtil.setNewRestrictions(targetDs);
        String currentUserKey = this.dhUserService.getLoggedInUserKey();
        String creator = targetDs.getCreator();
        if (!(creator.equals(currentUserKey) || this.dsAccessManager.canUserLoggedInEdit(targetDs) && !this.datasourceSharingSettingsController.isSharingRestricted())) {
            throw new DhUserException(403, "FORBIDDEN_DATASOURCE_OWNER", "Data source creator different than logged in user or user has no permissions to edit the datasource");
        }
        return targetDs;
    }

    @Override
    public DatasourceModel addDatasource(DatasourceModel newDs) throws IOException {
        List<DatasourceModel> datasources = this.getDatasources();
        DatasourceModel actualNewDs = this.dsGenerator.generateDatasource(newDs, datasources);
        this.validateCanMakeChangesBasedOnRestrictions(actualNewDs);
        DatasourceModel addedDatasource = this.dsRepo.addDatasource(actualNewDs);
        this.dsPermissionsController.updateDatasourcePermissions(addedDatasource);
        return addedDatasource;
    }

    @Override
    public DatasourceModel updateDatasource(DatasourceModel updatedDs) throws IOException {
        if (updatedDs.getId() == null) {
            throw new BadDatasourceException("The data source id cannot be null");
        }
        DatasourceModel targetDs = this.dsRepo.getDatasource(updatedDs.getId());
        DatasourcesUtil.setNewRestrictions(targetDs);
        String currentUserKey = this.dhUserService.getLoggedInUserKey();
        String creator = targetDs.getCreator();
        if (!creator.equals(currentUserKey) && !this.dsAccessManager.canUserLoggedInEdit(targetDs)) {
            throw new DhUserException(403, "FORBIDDEN_DATASOURCE_OWNER", "Data source creator different than logged in user or user has no permissions to edit the datasource");
        }
        targetDs.setName(updatedDs.getName());
        targetDs.setType(updatedDs.getType());
        targetDs.setPrivate(updatedDs.getPrivate());
        targetDs.setRestrictions(updatedDs.getRestrictions());
        if (targetDs.getUrl() == null || targetDs.getUrl().equals(updatedDs.getUrl())) {
            DsOptionsModel options;
            if (targetDs.getUrl() == null) {
                targetDs.setUrl(updatedDs.getUrl());
            }
            DsOptionsModel newDsOptions = new DsOptionsModel();
            DsOptionsModel oldDsOptions = this.dsUtils.getSecretOptions(targetDs.getToken());
            Map oldDsOptionsOption = oldDsOptions.getOption("options", Map.class);
            if (oldDsOptionsOption != null) {
                oldDsOptionsOption.forEach(newDsOptions::addOtherConfig);
            }
            if ((options = updatedDs.getOptions()) != null && options.getOtherConfig() != null && !options.getOtherConfig().isEmpty()) {
                if ("customreports".equals(targetDs.getProduct())) {
                    List newHeaders = (List)options.getOtherConfig().get("headers");
                    newDsOptions.addOtherConfig("headers", newHeaders != null ? newHeaders : new ArrayList());
                    List newParams = (List)options.getOtherConfig().get("params");
                    newDsOptions.addOtherConfig("params", newParams != null ? newParams : new ArrayList());
                    options.getOtherConfig().entrySet().stream().filter(entry -> !"headers".equals(entry.getKey()) && !"params".equals(entry.getKey())).forEach(entry -> newDsOptions.addOtherConfig((String)entry.getKey(), entry.getValue()));
                } else {
                    options.getOtherConfig().forEach(newDsOptions::addOtherConfig);
                }
            }
            targetDs.setToken(null);
            targetDs.setOptions(newDsOptions);
        } else {
            targetDs.setUrl(updatedDs.getUrl());
            targetDs.setOptions(updatedDs.getOptions());
        }
        DatasourceModel newDs = this.dsGenerator.generateDatasource(targetDs, Collections.emptyList());
        this.validateCanMakeChangesBasedOnRestrictions(newDs);
        DatasourceModel updatedDatasource = this.dsRepo.updateDatasource(newDs);
        this.dsPermissionsController.updateDatasourcePermissions(updatedDatasource);
        return updatedDatasource;
    }

    @Override
    public DatasourceModel removeDatasource(String id) throws IOException {
        String userKey = this.dhUserService.getLoggedInUserKey();
        DatasourceModel ds = this.getDatasource(id);
        if (!this.dhUserService.isLoggedUserAdmin().booleanValue() && !ds.getCreator().equals(userKey)) {
            log.error("Problems with datasource: User not allowed to remove datasource.");
            throw new RuntimeException("User not allowed to remove datasource");
        }
        DatasourceModel removedDs = this.dsRepo.removeDatasource(id);
        if (removedDs != null) {
            this.dsPermissionsController.removeDatasourcePermissions(id);
        }
        return removedDs;
    }

    @Override
    public DatasourceModel getDefaultDatasource(String creator, String product) throws IOException {
        List<DatasourceModel> privateDatasources = this.dsRepo.getDatasourcesByOwner(creator);
        return privateDatasources.stream().filter(ds -> DatasourcesUtil.isDefaultDatasource(ds, product, creator)).findFirst().map(ds -> {
            DatasourcesUtil.setNewRestrictions(ds);
            return ds;
        }).orElse(null);
    }

    @Override
    public void updateBoardDatasourcesWithNewOwner(BoardModel board, String newOwner) throws IOException {
        DatasourceModel newInstanceDatasource = this.getDefaultDatasource(newOwner, board.getProduct());
        if (newInstanceDatasource == null || board.getData() == null) {
            return;
        }
        AtomicBoolean instanceDatasourceAdded = new AtomicBoolean(false);
        List<List<GadgetModel>> updatedData = this.updateGadgetsWithNewDatasource(board, newInstanceDatasource, instanceDatasourceAdded);
        List<String> gadgetDatasourceIds = this.extractGadgetDatasourceIds(updatedData);
        List<DatasourceModel> boardDatasources = this.filterAndMapBoardDatasources(board, gadgetDatasourceIds);
        this.addNewInstanceDatasourceIfNeeded(boardDatasources, newInstanceDatasource, instanceDatasourceAdded);
        board.setDatasources(boardDatasources.stream().collect(Collectors.toMap(DatasourceModel::getId, ds -> new DatasourceModel(ds.getCreator(), ds.getPrivate()))));
        board.setData(updatedData);
    }

    private List<List<GadgetModel>> updateGadgetsWithNewDatasource(BoardModel board, DatasourceModel newInstanceDatasource, AtomicBoolean instanceDatasourceAdded) {
        return board.getData().stream().map(slide -> slide.stream().map(gadget -> {
            DatasourceModel existingDatasource;
            if (gadget.getConfig() == null || gadget.getConfig().getDatasource() == null) {
                return gadget;
            }
            try {
                existingDatasource = this.getDatasource(gadget.getConfig().getDatasource().getId());
            }
            catch (IOException e) {
                throw new RuntimeException("Problems getting datasource", e);
            }
            if (existingDatasource != null && DatasourcesUtil.isDefaultDatasource(existingDatasource, board.getProduct(), existingDatasource.getCreator())) {
                instanceDatasourceAdded.set(true);
                gadget.getConfig().setDatasource(new DatasourceModel(newInstanceDatasource.getId()));
            }
            return gadget;
        }).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List<String> extractGadgetDatasourceIds(List<List<GadgetModel>> updatedData) {
        return updatedData.stream().flatMap(Collection::stream).map(gadget -> Optional.ofNullable(gadget.getConfig()).map(GadgetConfigModel::getDatasource).map(DatasourceModel::getId).orElse(null)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private List<DatasourceModel> filterAndMapBoardDatasources(BoardModel board, List<String> gadgetDatasourceIds) {
        return board.getDatasources().entrySet().stream().filter(entry -> gadgetDatasourceIds.contains(entry.getKey())).map(entry -> {
            ((DatasourceModel)entry.getValue()).setId((String)entry.getKey());
            return (DatasourceModel)entry.getValue();
        }).collect(Collectors.toList());
    }

    private void addNewInstanceDatasourceIfNeeded(List<DatasourceModel> boardDatasources, DatasourceModel newInstanceDatasource, AtomicBoolean instanceDatasourceAdded) {
        if (instanceDatasourceAdded.get() && boardDatasources.stream().noneMatch(ds -> ds.getId().equals(newInstanceDatasource.getId()))) {
            DatasourceModel reducedDatasource = new DatasourceModel(newInstanceDatasource.getId());
            reducedDatasource.setCreator(newInstanceDatasource.getCreator());
            reducedDatasource.setPrivate(newInstanceDatasource.getPrivate());
            boardDatasources.add(reducedDatasource);
        }
    }

    @Override
    public List<DatasourceModel> getBoardsDatasources(List<DatasourceModel> datasourcesWithPermission, List<BoardModel> boards) {
        if (boards == null || boards.isEmpty()) {
            this.sanitizeDatasources(datasourcesWithPermission);
            return datasourcesWithPermission;
        }
        List<DatasourceModel> datasources = this.extractDatasourcesFromBoards(boards, datasourcesWithPermission);
        this.addMissingDatasources(datasources, datasourcesWithPermission);
        this.sanitizeDatasources(datasources);
        return datasources;
    }

    @Override
    public DatasourceModel getGadgetDatasource(DashboardGadgetModel gadget) {
        if (gadget == null || !this.hasValidDatasourceConfig(gadget)) {
            return null;
        }
        try {
            DatasourceModel datasource = this.getDatasource(gadget.getConfig().getDatasource().getId());
            if (datasource == null) {
                log.debug("Datasource not found for gadget with datasource ID: {}", (Object)gadget.getConfig().getDatasource().getId());
                return null;
            }
            return this.createLimitedDatasourceFrom(datasource);
        }
        catch (IOException e) {
            log.error("Error retrieving datasource for gadget", (Throwable)e);
            return null;
        }
    }

    private List<DatasourceModel> extractDatasourcesFromBoards(List<BoardModel> boards, List<DatasourceModel> datasourcesWithPermission) {
        return boards.stream().filter(board -> board.getData() != null).flatMap(board -> board.getData().stream()).flatMap(Collection::stream).filter(this::hasValidDatasourceConfig).map(widget -> this.resolveDatasource((GadgetModel)widget, datasourcesWithPermission)).filter(Objects::nonNull).filter(datasource -> datasource.getId() != null).collect(Collectors.collectingAndThen(Collectors.toMap(DatasourceModel::getId, datasource -> datasource, (existing, replacement) -> existing), map -> new ArrayList(map.values())));
    }

    private boolean hasValidDatasourceConfig(GadgetModel gadget) {
        return gadget.getConfig() != null && gadget.getConfig().getDatasource() != null && gadget.getConfig().getDatasource().getId() != null;
    }

    private DatasourceModel resolveDatasource(GadgetModel widget, List<DatasourceModel> datasourcesWithPermission) {
        String datasourceId = widget.getConfig().getDatasource().getId();
        return this.findDatasourceById(datasourceId, datasourcesWithPermission).orElseGet(() -> this.createLimitedDatasource(datasourceId));
    }

    private Optional<DatasourceModel> findDatasourceById(String datasourceId, List<DatasourceModel> datasources) {
        return datasources.stream().filter(ds -> Objects.equals(ds.getId(), datasourceId)).findFirst();
    }

    private DatasourceModel createLimitedDatasource(String datasourceId) {
        try {
            DatasourceModel fullDatasource = this.getDatasource(datasourceId);
            if (fullDatasource == null) {
                log.debug("Datasource with ID {} not found in database", (Object)datasourceId);
                return null;
            }
            return this.createLimitedDatasourceFrom(fullDatasource);
        }
        catch (IOException e) {
            log.error("Error retrieving datasource with ID {}", (Object)datasourceId, (Object)e);
            return null;
        }
    }

    private DatasourceModel createLimitedDatasourceFrom(DatasourceModel fullDatasource) {
        if (fullDatasource == null) {
            log.debug("Attempting to create limited datasource from null datasource");
            return null;
        }
        DatasourceModel limitedDatasource = new DatasourceModel();
        limitedDatasource.setId(fullDatasource.getId());
        limitedDatasource.setUrl(fullDatasource.getUrl());
        limitedDatasource.setType(fullDatasource.getType());
        limitedDatasource.setHidden(true);
        return limitedDatasource;
    }

    private void addMissingDatasources(List<DatasourceModel> finalDatasources, List<DatasourceModel> allDatasources) {
        allDatasources.stream().filter(ds -> !this.containsDatasourceWithId(ds.getId(), finalDatasources)).forEach(finalDatasources::add);
    }

    private boolean containsDatasourceWithId(String datasourceId, List<DatasourceModel> datasources) {
        return datasources.stream().anyMatch(ds -> Objects.equals(ds.getId(), datasourceId));
    }

    private void addHeadersParamsInfo(DatasourceModel ds) {
        try {
            DsOptionsModel options = this.dsUtils.getSecretOptions(ds.getToken());
            if (options != null && options.getOtherConfig() != null && options.getOtherConfig().get("options") != null) {
                List params;
                List headers;
                Map optionsMap = (Map)options.getOtherConfig().get("options");
                if (ds.getOptions() == null) {
                    ds.setOptions(new DsOptionsModel());
                }
                if ((headers = (List)optionsMap.get("headers")) != null) {
                    List headersInfo = headers.stream().map(header -> {
                        HashMap<String, String> headerInfo = new HashMap<String, String>();
                        headerInfo.put("key", (String)header.get("key"));
                        return headerInfo;
                    }).collect(Collectors.toList());
                    ds.getOptions().addOtherConfig("headers", headersInfo);
                }
                if ((params = (List)optionsMap.get("params")) != null) {
                    List paramsInfo = params.stream().map(param -> {
                        HashMap<String, String> paramInfo = new HashMap<String, String>();
                        paramInfo.put("key", (String)param.get("key"));
                        return paramInfo;
                    }).collect(Collectors.toList());
                    ds.getOptions().addOtherConfig("params", paramsInfo);
                }
            }
        }
        catch (Exception e) {
            log.warn("Could not add headers/params info for datasource: " + ds.getId(), (Throwable)e);
        }
    }

    private void sanitizeDatasources(List<DatasourceModel> datasources) {
        datasources.forEach(this::sanitizeDatasource);
    }

    private void sanitizeDatasource(DatasourceModel datasource) {
        if (datasource != null) {
            this.removeToken(datasource);
            this.removeRestrictions(datasource);
        }
    }

    private void removeToken(DatasourceModel datasource) {
        datasource.setToken(null);
    }

    private void removeRestrictions(DatasourceModel datasource) {
        datasource.setRestrictions(null);
    }
}

