/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.opsgenie;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.impl.opsgenie.functions.GetOpsGenieDataFunc;
import com.roninpixels.dashboardhub.connectors.interfaces.OpsgenieConnector;
import com.roninpixels.dashboardhub.utils.requests.ResponseChecker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class OpsgenieConnectorImpl
implements OpsgenieConnector {
    private static final Logger log = LoggerFactory.getLogger(OpsgenieConnectorImpl.class);
    public static final String PATH_USERS = "/v2/users";
    public static final String PATH_ALERTS = "/v2/alerts";
    public static final String PATH_SCHEDULES = "/v2/schedules";
    public static final String PATH_TEAMS = "/v2/teams";
    public static final String PATH_INCIDENTS = "/v1/incidents";
    private ServerConnector connector;

    public OpsgenieConnectorImpl(ServerConnector connector) {
        this.connector = connector;
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public boolean isValid() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", "1");
        ResponseEntity<List> resp = this.listUsers(params);
        ResponseChecker.checkStatus(resp);
        return true;
    }

    @Override
    public ResponseEntity<List> listUsers(Map<String, String> params) {
        return new GetOpsGenieDataFunc(this.connector, PATH_USERS).exec(params);
    }

    @Override
    public ResponseEntity<String> getAlerts(Map<String, String> params) {
        HashMap<String, String> mParams = params != null ? new HashMap<String, String>(params) : new HashMap();
        mParams.putIfAbsent("limit", "100");
        mParams.putIfAbsent("offset", "0");
        return this.connector.executeRequest(PATH_ALERTS, mParams);
    }

    @Override
    public ResponseEntity<List> getSchedules(Map<String, String> params) {
        return new GetOpsGenieDataFunc(this.connector, PATH_SCHEDULES).exec(params);
    }

    @Override
    public ResponseEntity<String> getSchedule(String scheduleId) {
        String path = String.format("/v2/schedules/%s", scheduleId);
        return this.connector.executeRequest(path);
    }

    @Override
    public ResponseEntity<String> getScheduleTimeline(String scheduleId, Map<String, String> params) {
        String path = String.format("/v2/schedules/%s/timeline", scheduleId);
        return this.connector.executeRequest(path, params);
    }

    @Override
    public ResponseEntity<List> listTeams(Map<String, String> params) {
        return new GetOpsGenieDataFunc(this.connector, PATH_TEAMS).exec(params);
    }

    @Override
    public ResponseEntity<String> getTeam(String teamId) {
        String path = String.format("/v2/teams/%s", teamId);
        return this.connector.executeRequest(path);
    }

    @Override
    public ResponseEntity<List> getIncidents(Map<String, String> params) {
        return new GetOpsGenieDataFunc(this.connector, PATH_INCIDENTS).exec(params);
    }
}

