/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.jira.common.functions;

import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GetBoardsSprintsFunc {
    private static final Logger log = LoggerFactory.getLogger(GetBoardsSprintsFunc.class);
    public static String PATH_PATTERN = "/rest/agile/1.0/board/%d/sprint";
    private final ServerConnector connector;

    public GetBoardsSprintsFunc(ServerConnector jiraConnector) {
        this.connector = jiraConnector;
    }

    public ResponseEntity<List> execute(Long boardId, Map<String, ?> params, Map<String, Object> paginationOptions) {
        boolean loadAll = paginationOptions == null || (Boolean)paginationOptions.getOrDefault("all", true) != false;
        String path = String.format(PATH_PATTERN, boardId);
        HashMap<String, Integer> mParams = params == null ? new HashMap<String, Integer>() : new HashMap(params);
        mParams.putIfAbsent("startAt", 0);
        boolean moreData = true;
        LinkedList sprints = new LinkedList();
        do {
            ResponseEntity<Map> response;
            if ((response = this.connector.executeRequest(path, mParams, Map.class)).getStatusCode().value() >= 400) {
                return new ResponseEntity(response.getStatusCode());
            }
            Map responseData = (Map)response.getBody();
            sprints.addAll((List)responseData.get("values"));
            Boolean isLast = (Boolean)responseData.get("isLast");
            if (isLast != Boolean.TRUE && loadAll && sprints.size() < 1000) {
                int next = (Integer)responseData.get("startAt") + (Integer)responseData.get("maxResults");
                mParams.put("startAt", next);
                continue;
            }
            moreData = false;
        } while (moreData);
        return new ResponseEntity(sprints, HttpStatus.OK);
    }
}

