/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.impl.atlassianInsight;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.impl.atlassianInsight.functions.SearchByIQLFunc;
import com.roninpixels.dashboardhub.connectors.impl.genericServer.ServerConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.AtlassianInsightConnector;
import com.roninpixels.dashboardhub.connectors.interfaces.ImageProvider;
import com.roninpixels.dashboardhub.exceptions.DhUserException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class AtlassianInsightConnectorImpl
implements AtlassianInsightConnector,
ImageProvider {
    private static final Logger log = LoggerFactory.getLogger(AtlassianInsightConnectorImpl.class);
    protected ServerConnector connector;

    public AtlassianInsightConnectorImpl(ServerConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean isValid() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("iql", "ObjectType=random-string-" + System.currentTimeMillis());
            ResponseEntity<Map> resp = this.searchByIQL(params);
            if (resp.getStatusCode().value() > 400) {
                throw new DhUserException(resp.getStatusCode().value(), "INVALID_INSTANCE", " Generic error when the data source validation fails");
            }
            return true;
        }
        catch (DhUserException dhe) {
            throw dhe;
        }
        catch (Exception e) {
            log.error("Validation of connector failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getURL() {
        return this.connector.getURL();
    }

    @Override
    public ResponseEntity<String> findObjectSchemas(Map<String, String> params) {
        return this.connector.executeRequest("/objectschema/list", params);
    }

    @Override
    public ResponseEntity<Map> searchByIQL(Map<String, String> params) {
        return new SearchByIQLFunc(this.connector).exec(params);
    }

    @Override
    public ResponseEntity<String> getWorkspaces() {
        String PATH_WORKSPACES = "/rest/servicedeskapi/assets/workspace";
        Map<String, String> headers = Collections.singletonMap("X-ExperimentalApi", "opt-in");
        return this.connector.executeRequest(Request.MethodType.GET, PATH_WORKSPACES, Collections.emptyMap(), headers, String.class);
    }

    @Override
    public ResponseEntity<InputStream> getImage(String path) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "image/*");
        headers.put("encoding", "binary");
        ResponseEntity<InputStream> response = this.connector.executeRequest(Request.MethodType.GET, path, null, headers, InputStream.class);
        return response;
    }
}

