/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors.authStrategy.strategies;

import com.atlassian.sal.api.net.Request;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.AuthStrategyWithQueryParams;
import com.roninpixels.dashboardhub.connectors.authStrategy.strategies.TokenAuthStrategy;
import com.roninpixels.dashboardhub.exceptions.BadDatasourceException;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.DsOptionsModel;
import java.util.Map;
import org.springframework.web.util.UriComponentsBuilder;

public class APITokenAuthStrategy
extends TokenAuthStrategy
implements AuthStrategyWithQueryParams {
    public APITokenAuthStrategy(DatasourceModel datasource) {
        super(datasource);
    }

    private Request legacy(Request request, Map options) {
        String apiToken = (String)options.get("token");
        if (apiToken != null) {
            String authValue = String.format("APIToken %s", apiToken);
            return request.addHeader("Authorization", authValue);
        }
        throw new RuntimeException("API Token not defined");
    }

    private Request customReportsApiToken(Request request, Map options, UriComponentsBuilder builder) {
        String key = (String)options.get("key");
        String value = (String)options.get("value");
        Object addTo = options.get("addTo");
        if ("header".equals(addTo)) {
            request.addHeader(key, value);
        } else if (!"query".equals(addTo)) {
            throw new BadDatasourceException(String.format("Unsupported configuration for APIToken: %s", addTo));
        }
        return request;
    }

    @Override
    public Request applyAuthenticationStrategy(Request request, UriComponentsBuilder builder) {
        DsOptionsModel dsOptions = this.getOptions(this.datasource.getToken());
        Map options = dsOptions.getOption("options", Map.class);
        if ("apikey".equals(options.get("type"))) {
            return this.customReportsApiToken(request, options, builder);
        }
        return this.legacy(request, options);
    }

    @Override
    public void addParameters(UriComponentsBuilder builder) {
        DsOptionsModel dsOptions = this.getOptions(this.datasource.getToken());
        Map options = dsOptions.getOption("options", Map.class);
        Object addTo = options.get("addTo");
        if ("apikey".equals(options.get("type")) && "query".equals(addTo)) {
            String key = (String)options.get("key");
            String value = (String)options.get("value");
            builder.queryParam(key, new Object[]{value});
        }
    }
}

