/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.connectors;

import com.roninpixels.dashboardhub.connectors.ConnectorsFactory;
import com.roninpixels.dashboardhub.connectors.factories.ConnectorFactory;
import com.roninpixels.dashboardhub.connectors.interfaces.DHConnector;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConnectorsFactoryImpl
implements ConnectorsFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectorsFactoryImpl.class);
    @Inject
    private List<ConnectorFactory> factories;

    @Override
    public DHConnector getConnector(DatasourceModel ds) {
        ConnectorFactory factory2;
        if (ds == null) {
            throw new IllegalArgumentException("The datasource cannot be null");
        }
        List factories = this.factories.stream().filter(factory -> factory.match(ds)).collect(Collectors.toList());
        switch (factories.size()) {
            case 0: {
                throw new RuntimeException("Connector not supported: " + ds.getProduct());
            }
            case 1: {
                factory2 = (ConnectorFactory)factories.get(0);
                break;
            }
            default: {
                log.warn(String.format("Found multiple factories for a datasource: %s. Returning the first one.", ds.getName()));
                factory2 = (ConnectorFactory)factories.get(0);
            }
        }
        return factory2.createConnector(ds);
    }
}

