/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.config.dhDefault;

import com.roninpixels.dashboardhub.config.dhDefault.DefaultDatasourceCreator;
import com.roninpixels.dashboardhub.migrations.DHMigrationTask;
import com.roninpixels.dashboardhub.migrations.DHTasksEngine;
import com.roninpixels.dashboardhub.services.DHDefaultConfigGenerator;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultConfiguration
implements DHDefaultConfigGenerator {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfiguration.class);
    private static final boolean defaultDatasourcePrivate = true;
    @Inject
    private DatasourcesController dsController;
    @Autowired(required=false)
    private Provider<List<DHMigrationTask>> migrationTasksProvider;
    @Inject
    private DefaultDatasourceCreator datasourceCreator;
    @Inject
    private DHTasksEngine tasksEngine;

    @Override
    public void ensureDefaultDatasource() {
        if (!this.datasourceCreator.isDefaultDatasourceProvided()) {
            return;
        }
        try {
            List<DatasourceModel> datasources = this.dsController.getDatasources();
            boolean alreadyExists = this.isAlreadyCreated(datasources);
            if (alreadyExists) {
                log.debug("Default Jira datasources is already created. Cool!");
            } else {
                DatasourceModel defaultDS = this.datasourceCreator.createDefaultDatasource();
                this.dsController.addDatasource(defaultDS);
                log.debug("Default datasource created!!!!");
            }
        }
        catch (Exception e) {
            log.error("Problems creating the default datasource", (Throwable)e);
        }
    }

    @Override
    public DatasourceModel getDefaultDatasource() {
        if (!this.datasourceCreator.isDefaultDatasourceProvided()) {
            return null;
        }
        try {
            List<DatasourceModel> datasources = this.dsController.getDatasources();
            return this.datasourceCreator.findDefaultDatasource(datasources);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean isAlreadyCreated(List<DatasourceModel> currentDatasources) {
        return this.datasourceCreator.isDefaultDatasourceProvided() && this.datasourceCreator.findDefaultDatasource(currentDatasources) != null;
    }

    private void executeMigrationTasks() {
        if (this.migrationTasksProvider.get() != null && !((List)this.migrationTasksProvider.get()).isEmpty()) {
            ((List)this.migrationTasksProvider.get()).stream().forEach(task -> task.execute());
        }
    }
}

