/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.config.action;

import com.roninpixels.dashboardhub.config.DHStaticResources;
import com.roninpixels.dashboardhub.config.DashboardHubConfig;
import com.roninpixels.dashboardhub.config.FrontendConfigurationService;
import com.roninpixels.dashboardhub.config.action.DHAction;
import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.config.frontedModel.FrontendConfigModel;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.controllers.BoardsController;
import com.roninpixels.dashboardhub.controllers.UserPreferencesController;
import com.roninpixels.dashboardhub.services.DHDefaultConfigGenerator;
import com.roninpixels.dashboardhub.services.DHUserService;
import com.roninpixels.dashboardhub.services.controllers.DatasourcesController;
import com.roninpixels.dashboardhub.services.model.AppUser;
import com.roninpixels.dashboardhub.utils.deserializer.DHObjectMapper;
import com.roninpixels.dashboardhub.web.models.BoardModel;
import com.roninpixels.dashboardhub.web.models.DashboardGadgetModel;
import com.roninpixels.dashboardhub.web.models.DatasourceModel;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import com.roninpixels.dashboardhub.web.models.UserPreferencesModel;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHShowActionBase
implements DHAction {
    private static final Logger log = LoggerFactory.getLogger(DHShowActionBase.class);
    @Inject
    protected FrontendConfigurationService configService;
    @Inject
    protected DashboardHubConfig dashboardHubConfig;
    @Inject
    protected BoardsController boardsController;
    @Inject
    protected UserPreferencesController userPreferencesController;
    @Inject
    protected AccessManagementController accessManagementController;
    @Inject
    private DHObjectMapper mapper;
    @Inject
    private DHStaticResources dhStaticResources;
    @Inject
    private DHUserService dhUserService;
    @Inject
    private DatasourcesController datasourcesController;
    @Inject
    private DHDefaultConfigGenerator defaultConfiguration;
    protected TokenContentModel tokenData;

    @Override
    public void setToken(TokenContentModel tokenContent) {
        this.tokenData = tokenContent;
    }

    @Override
    public DashboardHubConfig getDashboardHubConfig() {
        return this.dashboardHubConfig;
    }

    @Override
    public String getConfig() {
        try {
            FrontendConfigModel config = this.configService.createConfig();
            if (this.tokenData != null) {
                config.setWallboard(this.getSerializedBoard());
                if (config.getWallboard() == null) {
                    config.setDhError("FORBIDDEN");
                }
                config.setSharedBoard(config.getWallboard());
            }
            return this.configService.serializeConfig(config);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }

    private String getSerializedBoard() {
        if (this.tokenData != null) {
            try {
                BoardModel board = this.boardsController.getUserBoard(this.tokenData.getUsserAccountId(), this.tokenData.getBoardId(), this.tokenData.getGlobal());
                if (this.boardsController.checkUserLoggedCanView(board)) {
                    String json = this.mapper.writeValueAsString(board);
                    return json;
                }
            }
            catch (Exception e) {
                log.error("Problems getting a board for internal sharing -> " + this.tokenData.getBoardId(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getAppConfig() {
        AppConfigModel appConfig = this.accessManagementController.getConfig(true);
        try {
            return this.configService.serializeConfig(appConfig);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }

    @Override
    public String getDHStaticResources(String resource) {
        return this.dhStaticResources.getResource(resource);
    }

    @Override
    public void validate() {
    }

    @Override
    public String getPreloaded() {
        return null;
    }

    public String getPreloadedByBoard(List<BoardModel> boards) {
        try {
            HashMap<String, Object> preloaded = new HashMap<String, Object>();
            preloaded.put("sharedBoards", boards);
            preloaded.put("privateBoards", Collections.emptyList());
            preloaded.put("globalBoards", Collections.emptyList());
            preloaded.put("datasources", this.datasourcesController.getBoardsDatasources(Collections.emptyList(), boards));
            return this.encodeToBase64(preloaded);
        }
        catch (Exception e) {
            log.error("Problems mapping preloaded data", (Throwable)e);
            return null;
        }
    }

    public String getPreloadedByLoggedUser() {
        try {
            AppUser user = this.dhUserService.getLoggedInUser();
            if (user == null) {
                return null;
            }
            Map<String, Object> preloadedData = this.buildPreloadedData(user);
            return this.encodeToBase64(preloadedData);
        }
        catch (Exception e) {
            log.error("Problems getting preloaded data", (Throwable)e);
            return null;
        }
    }

    public String getPreloadedByGadget(DashboardGadgetModel gadget) {
        try {
            HashMap<String, Object> preloaded = new HashMap<String, Object>();
            ArrayList<DatasourceModel> datasources = new ArrayList<DatasourceModel>();
            DatasourceModel gadgetDatasource = this.datasourcesController.getGadgetDatasource(gadget);
            if (gadgetDatasource == null) {
                return null;
            }
            datasources.add(gadgetDatasource);
            preloaded.put("datasources", datasources);
            return this.encodeToBase64(preloaded);
        }
        catch (Exception e) {
            log.error("Problems getting preloaded data", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> buildPreloadedData(AppUser user) throws Exception {
        List<DatasourceModel> datasourcesWithPermission = this.getDatasourcesWithPermission(user);
        List sharedBoards = this.boardsController.getAllSharedWithMeBoards(true);
        List globalBoards = this.boardsController.getAllBoards(true, true);
        List privateBoards = this.boardsController.getAllBoards(false, true);
        List<BoardModel> allBoards = Stream.of(sharedBoards, globalBoards, privateBoards).flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sharedBoards", sharedBoards);
        result.put("privateBoards", privateBoards);
        result.put("globalBoards", globalBoards);
        result.put("datasources", this.datasourcesController.getBoardsDatasources(datasourcesWithPermission, allBoards));
        Map<String, Object> userPrefsMap = this.getRecentlyBoardsUserPreferences(user);
        if (userPrefsMap != null) {
            result.put("preferences", userPrefsMap);
        }
        return result;
    }

    private Map<String, Object> getRecentlyBoardsUserPreferences(AppUser user) {
        UserPreferencesModel userPreferences = this.userPreferencesController.getUserPreference(user.getKey());
        HashMap<String, List> userPrefsMap = null;
        if (userPreferences != null) {
            userPrefsMap = new HashMap<String, List>();
            userPrefsMap.put("recentlyBoards", userPreferences.getRecentlyBoards());
        }
        return userPrefsMap;
    }

    private List<DatasourceModel> getDatasourcesWithPermission(AppUser user) throws Exception {
        List<DatasourceModel> datasources = this.datasourcesController.getDatasources(user.getKey());
        if (!this.defaultConfiguration.isAlreadyCreated(datasources)) {
            this.defaultConfiguration.ensureDefaultDatasource();
            datasources = this.datasourcesController.getDatasources(user.getKey());
        }
        return datasources;
    }

    private String encodeToBase64(Map<String, Object> data) throws Exception {
        String jsonValue = this.mapper.writeValueAsString(data);
        return Base64.getEncoder().encodeToString(jsonValue.getBytes(StandardCharsets.UTF_8));
    }
}

