/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.analytics;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginEnablingEvent;
import com.atlassian.plugin.event.events.PluginEvent;
import com.atlassian.plugin.event.events.PluginInstalledEvent;
import com.atlassian.plugin.event.events.PluginInstallingEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUninstallingEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.roninpixels.dashboardhub.services.DashboardHubPluginManager;
import com.roninpixels.dashboards.analytics.amplitude.AnalyticsService;
import com.roninpixels.dashboards.analytics.amplitude.EventDetails;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AppfireEventListener {
    private static final Logger log = LoggerFactory.getLogger(AppfireEventListener.class);
    @Inject
    @ComponentImport
    private EventPublisher eventPublisher;
    @Inject
    private AnalyticsService analyticsService;
    private DashboardHubPluginManager dashboardHubPluginManager;
    private String pluginKey;

    @Inject
    public AppfireEventListener(DashboardHubPluginManager dhPluginManager) {
        this.dashboardHubPluginManager = dhPluginManager;
        this.pluginKey = this.dashboardHubPluginManager.getPluginKey();
    }

    @PostConstruct
    public void register() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregister() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPluginEvent(PluginEvent event) {
        String eventPluginKey = event.getPlugin().getKey();
        log.info("Plugin enabled: {}", (Object)event.getPlugin().getKey());
        if (!eventPluginKey.equals(this.pluginKey)) {
            return;
        }
        log.info("Event received: " + event);
        if (!(event instanceof PluginEnablingEvent)) {
            if (event instanceof PluginEnabledEvent) {
                EventDetails eventDetails = new EventDetails();
                eventDetails.setEventName("AppEnabled");
                HashMap<String, Object> eventDataMap = new HashMap<String, Object>();
                eventDetails.setEventData(eventDataMap);
                this.analyticsService.addEvent(eventDetails);
            } else if (!(event instanceof PluginInstallingEvent)) {
                if (event instanceof PluginInstalledEvent) {
                    EventDetails eventDetails = new EventDetails();
                    eventDetails.setEventName("AppInstalled");
                    HashMap<String, Object> eventDataMap = new HashMap<String, Object>();
                    eventDataMap.put("app_version", this.dashboardHubPluginManager.getPluginVersion());
                    eventDetails.setEventData(eventDataMap);
                    this.analyticsService.addEvent(eventDetails);
                } else if (event instanceof PluginDisablingEvent) {
                    EventDetails eventDetails = new EventDetails();
                    eventDetails.setEventName("AppDisabled");
                    this.analyticsService.addEvent(eventDetails);
                } else if (!(event instanceof PluginDisabledEvent)) {
                    if (event instanceof PluginUninstallingEvent) {
                        EventDetails eventDetails = new EventDetails();
                        eventDetails.setEventName("AppUninstalled");
                        this.analyticsService.addEvent(eventDetails);
                    } else if (event instanceof PluginUninstalledEvent) {
                        // empty if block
                    }
                }
            }
        }
    }
}

