/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.datacentercompatibility.impl;

import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.ProductLicense;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;

public class CompatibilityHostLicenseInformation
implements HostLicenseInformation {
    private final LazyReference<Boolean> dataCenterImplemented;
    private final com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation;
    private final LicenseHandler licenseHandler;

    public CompatibilityHostLicenseInformation(final com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, LicenseHandler licenseHandler) {
        this.upmHostLicenseInformation = upmHostLicenseInformation;
        this.licenseHandler = licenseHandler;
        this.dataCenterImplemented = new LazyReference<Boolean>(){

            @Override
            protected Boolean create() throws Exception {
                try {
                    upmHostLicenseInformation.isEvaluation();
                    return true;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return false;
                }
            }
        };
    }

    @Override
    public Option<String> hostSen() {
        return this.upmHostLicenseInformation.hostSen();
    }

    @Override
    public boolean isDataCenter() {
        if (this.dataCenterImplemented.get().booleanValue()) {
            return this.upmHostLicenseInformation.isDataCenter();
        }
        return this.dataCenterFromSal();
    }

    @Override
    public Option<Integer> getEdition() {
        if (this.dataCenterImplemented.get().booleanValue()) {
            return this.upmHostLicenseInformation.getEdition();
        }
        return this.editionFromSal();
    }

    @Override
    public boolean isEvaluation() {
        if (this.dataCenterImplemented.get().booleanValue()) {
            return this.upmHostLicenseInformation.isEvaluation();
        }
        return this.evaluationFromSal();
    }

    private boolean dataCenterFromSal() {
        return this.getLicenses().stream().anyMatch(BaseLicenseDetails::isDataCenter);
    }

    private boolean evaluationFromSal() {
        Collection<SingleProductLicenseDetailsView> licenses = this.getLicenses();
        return !licenses.isEmpty() && licenses.stream().allMatch(BaseLicenseDetails::isEvaluationLicense);
    }

    private Option<Integer> editionFromSal() {
        Collection licenses = this.getLicenses().stream().filter(l -> !l.isEvaluationLicense()).collect(Collectors.toList());
        if (licenses.stream().anyMatch(ProductLicense::isUnlimitedNumberOfUsers)) {
            return Option.none();
        }
        return licenses.stream().map(ProductLicense::getNumberOfUsers).max(Comparator.naturalOrder()).map(Option::some).orElse(Option.none());
    }

    private Collection<SingleProductLicenseDetailsView> getLicenses() {
        return this.licenseHandler.getProductKeys().stream().map(arg_0 -> ((LicenseHandler)this.licenseHandler).getProductLicenseDetails(arg_0)).collect(Collectors.toList());
    }
}

